/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.items;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncMagicData;
import by.dragonsurvivalteam.dragonsurvival.network.syncing.SyncComplete;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAdvancementTriggers;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSDragonSpeciesTags;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.PlayerLoginHandler;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class DragonSoulItem
extends Item {
    @Translation(comments={"Empty Dragon Soul"})
    private static final String EMPTY_DRAGON_SOUL = Translation.Type.ITEM.wrap("empty_dragon_soul");
    @Translation(comments={" Soul"})
    private static final String SOUL = Translation.Type.DESCRIPTION.wrap("dragon_soul.soul");
    @Translation(comments={"\u25a0\u00a77 This vessel holds the dragon's soul. Use it to become a dragon. Replaces your current stats if you are a dragon.\n"})
    private static final String DESCRIPTION = Translation.Type.DESCRIPTION.wrap("dragon_soul");
    @Translation(comments={"\u00a76\u25a0 Species:\u00a7r %s\n\u00a76\u25a0 Growth Stage:\u00a7r %s\n\u00a76\u25a0 Growth:\u00a7r %s\n"})
    private static final String INFO = Translation.Type.DESCRIPTION.wrap("dragon_soul.info");
    @Translation(comments={"\u25a0\u00a77 An empty dragon's soul. With this item, you can store all your dragon's characteristics. After using it, you become human."})
    private static final String IS_EMPTY = Translation.Type.DESCRIPTION.wrap("dragon_soul.empty");
    @Translation(comments={"Invalid dragon type"})
    private static final String INVALID_DRAGON_TYPE = Translation.Type.DESCRIPTION.wrap("dragon_soul.invalid_type");
    @ConfigRange(min=0.0)
    @Translation(key="dragon_soul_cooldown", type=Translation.Type.CONFIGURATION, comments={"Cooldown (in ticks) (20 ticks = 1 second) that occurs after using the dragon soul"})
    @ConfigOption(side=ConfigSide.SERVER, category={"items", "dragon_soul"}, key="dragon_soul_cooldown")
    public static int COOLDOWN = Functions.secondsToTicks(60.0);
    private static final String DRAGON = "dragon";
    private static final String ABILITIES = "soul";

    public DragonSoulItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (DragonStateProvider.isDragon((Entity)player) || player.getItemInHand(hand).has(DataComponents.CUSTOM_DATA)) {
            player.startUsingItem(hand);
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
    }

    private static int getCustomModelData(@NotNull HolderLookup.Provider provider, CompoundTag tag) {
        ResourceKey<DragonSpecies> species = ResourceHelper.decodeKey(provider, DragonSpecies.REGISTRY, tag, "dragon_species");
        if (species == null) {
            return 0;
        }
        Holder dragonSpecies = provider.holderOrThrow(species);
        if (dragonSpecies.is(DSDragonSpeciesTags.FOREST_DRAGONS)) {
            return 1;
        }
        if (dragonSpecies.is(DSDragonSpeciesTags.CAVE_DRAGONS)) {
            return 2;
        }
        if (dragonSpecies.is(DSDragonSpeciesTags.SEA_DRAGONS)) {
            return 3;
        }
        return 0;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        ServerPlayer serverPlayer;
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer2 = (ServerPlayer)player;
            DSAdvancementTriggers.USE_DRAGON_SOUL.get().trigger(serverPlayer2);
        }
        DragonStateHandler handler = DragonStateProvider.getData(player);
        MagicData magicData = MagicData.getData(player);
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData != null && !customData.getUnsafe().getCompound(DRAGON).isEmpty()) {
            if (handler.isDragon()) {
                tag = customData.copyTag();
                CompoundTag storedDragonData = tag.getCompound(DRAGON);
                CompoundTag currentDragonData = handler.serializeNBT((HolderLookup.Provider)level.registryAccess(), true);
                boolean flightGranted = handler.flightWasGranted;
                boolean spinGranted = handler.spinWasGranted;
                handler.deserializeNBT((HolderLookup.Provider)level.registryAccess(), storedDragonData, true);
                handler.flightWasGranted = flightGranted;
                handler.spinWasGranted = spinGranted;
                CompoundTag storedAbilityData = tag.getCompound(ABILITIES);
                CompoundTag currentAbilityData = magicData.serializeNBTForCurrentSpecies((HolderLookup.Provider)level.registryAccess());
                magicData.setCurrentSpecies(player, handler.speciesKey());
                magicData.deserializeNBTForCurrentSpecies((HolderLookup.Provider)level.registryAccess(), storedAbilityData);
                CompoundTag combinedData = new CompoundTag();
                combinedData.put(DRAGON, (Tag)currentDragonData);
                combinedData.put(ABILITIES, (Tag)currentAbilityData);
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)combinedData));
                stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(DragonSoulItem.getCustomModelData((HolderLookup.Provider)level.registryAccess(), currentDragonData)));
            } else {
                tag = customData.copyTag();
                boolean flightGranted = handler.flightWasGranted;
                boolean spinGranted = handler.spinWasGranted;
                handler.deserializeNBT((HolderLookup.Provider)level.registryAccess(), tag.getCompound(DRAGON), true);
                handler.flightWasGranted = flightGranted;
                handler.spinWasGranted = spinGranted;
                magicData.setCurrentSpecies(player, handler.speciesKey());
                magicData.deserializeNBTForCurrentSpecies((HolderLookup.Provider)level.registryAccess(), tag.getCompound(ABILITIES));
                stack.set(DataComponents.CUSTOM_DATA, null);
                stack.set(DataComponents.CUSTOM_MODEL_DATA, null);
            }
        } else if (handler.isDragon()) {
            CompoundTag currentDragonData = handler.serializeNBT((HolderLookup.Provider)level.registryAccess(), true);
            CompoundTag currentAbilityData = magicData.serializeNBTForCurrentSpecies((HolderLookup.Provider)level.registryAccess());
            CompoundTag combinedData = customData == null ? new CompoundTag() : customData.copyTag();
            combinedData.put(DRAGON, (Tag)currentDragonData);
            combinedData.put(ABILITIES, (Tag)currentAbilityData);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)combinedData));
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(DragonSoulItem.getCustomModelData((HolderLookup.Provider)level.registryAccess(), currentDragonData)));
            handler.revertToHumanForm(player, true);
        }
        if (!player.isCreative()) {
            player.getCooldowns().addCooldown(stack.getItem(), COOLDOWN);
        }
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            SyncComplete.handleDragonSync(serverPlayer, false);
            PlayerLoginHandler.syncHandler(serverPlayer);
        }
        if (handler.isDragon()) {
            handler.setGrowth(player, handler.getGrowth(), true);
        }
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncMagicData(magicData.serializeNBT((HolderLookup.Provider)player.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ENDER_DRAGON_GROWL, entity.getSoundSource(), 1.0f, 1.0f);
        for (int i = 0; i < 10; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.SOUL, entity.getX() + (level.random.nextDouble() - 0.5) * 0.5, entity.getY() + (level.random.nextDouble() - 0.5) * 0.5, entity.getZ() + (level.random.nextDouble() - 0.5) * 0.5, (level.random.nextDouble() - 0.5) * 0.5, level.random.nextDouble() * 0.5, (level.random.nextDouble() - 0.5) * 0.5);
        }
        return stack;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.CUSTOM;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return Functions.secondsToTicks(2.0);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltips, flag);
        HolderLookup.Provider provider = context.registries();
        if (provider == null) {
            return;
        }
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).getUnsafe().getCompound(DRAGON);
            tooltips.add((Component)Component.translatable((String)DESCRIPTION));
            ResourceKey<DragonSpecies> species = ResourceHelper.decodeKey(provider, DragonSpecies.REGISTRY, tag, "dragon_species");
            MutableComponent name = species != null ? Component.translatable((String)Translation.Type.DRAGON_SPECIES.wrap(species.location())) : Component.translatable((String)INVALID_DRAGON_TYPE);
            double growth = tag.getDouble("growth");
            Holder<DragonStage> stage = DragonStage.get(provider, growth);
            tooltips.add((Component)Component.translatable((String)INFO, (Object[])new Object[]{name, DragonStage.translatableName((ResourceKey<DragonStage>)stage.getKey()), String.format("%.0f", growth)}));
        } else {
            tooltips.add((Component)Component.translatable((String)IS_EMPTY));
        }
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity entity, @NotNull ItemStack soul, int remainingUseDuration) {
        super.onUseTick(level, entity, soul, remainingUseDuration);
        entity.playSound((SoundEvent)SoundEvents.SOUL_ESCAPE.value(), (float)(0.3 + 0.3 * (double)entity.getRandom().nextInt(2)), entity.getRandom().nextFloat() - entity.getRandom().nextFloat() * 0.2f + 1.0f);
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has(DataComponents.CUSTOM_DATA);
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        ResourceKey<DragonSpecies> species;
        if (stack.has(DataComponents.CUSTOM_DATA) && (species = ResourceHelper.decodeKey(null, DragonSpecies.REGISTRY, ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).getUnsafe().getCompound(DRAGON), "dragon_species")) != null) {
            return Component.translatable((String)Translation.Type.DRAGON_SPECIES.wrap(species.location())).append((Component)Component.translatable((String)SOUL));
        }
        return Component.translatable((String)EMPTY_DRAGON_SOUL);
    }
}

