/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers.magic;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.claw.SyncBrokenTool;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ClawInventoryData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.HarvestBonuses;
import by.dragonsurvivalteam.dragonsurvival.util.ToolUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerDestroyItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class ClawToolHandler {
    @SubscribeEvent
    public static void experiencePickup(PlayerXpEvent.PickupXp event) {
        Player player = event.getEntity();
        if (!DragonStateProvider.isDragon((Entity)player)) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        SimpleContainer clawInventory = ClawInventoryData.getData(player).getContainer();
        for (int i = 0; i < ClawInventoryData.Slot.size(); ++i) {
            ItemStack clawStack = clawInventory.getItem(i);
            if (!clawStack.isDamaged() || !EnchantmentHelper.has((ItemStack)clawStack, (DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP)) continue;
            stacks.add(clawStack);
        }
        if (stacks.isEmpty()) {
            return;
        }
        ItemStack repairTime = (ItemStack)stacks.get(player.getRandom().nextInt(stacks.size()));
        if (!repairTime.isEmpty() && repairTime.isDamaged()) {
            int i = Math.min((int)((float)event.getOrb().value * repairTime.getXpRepairRatio()), repairTime.getDamageValue());
            event.getOrb().value -= i * 2;
            repairTime.setDamageValue(repairTime.getDamageValue() - i);
        }
        event.getOrb().value = Math.max(0, event.getOrb().value);
        player.detectEquipmentUpdates();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void playerDieEvent(LivingDropsEvent event) {
        Player player;
        LivingEntity livingEntity;
        if (!ServerConfig.retainClawItems.booleanValue() && (livingEntity = event.getEntity()) instanceof Player && !(player = (Player)livingEntity).level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            SimpleContainer clawInventory = ClawInventoryData.getData(player).getContainer();
            for (int i = 0; i < ClawInventoryData.Slot.size(); ++i) {
                ItemStack stack = clawInventory.getItem(i);
                if (stack.isEmpty() || EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
                event.getDrops().add(new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), stack));
                clawInventory.setItem(i, ItemStack.EMPTY);
            }
        }
    }

    @SubscribeEvent
    public static void dropBlocksMinedByPaw(PlayerEvent.HarvestCheck event) {
        if (event.canHarvest()) {
            return;
        }
        Player player = event.getEntity();
        DragonStateHandler data = DragonStateProvider.getData(player);
        boolean canHarvest = data.isDragon() ? data.canHarvestWithPaw(player, event.getTargetBlock()) : HarvestBonuses.canHarvest(player, event.getTargetBlock(), player.getMainHandItem());
        if (canHarvest) {
            event.setCanHarvest(true);
        }
    }

    public static ItemStack getDragonHarvestTool(Player player, BlockState state) {
        ItemStack mainStack = player.getInventory().getSelected();
        float newSpeed = 0.0f;
        if (!ToolUtils.shouldUseDragonTools(mainStack)) {
            return mainStack;
        }
        ItemStack harvestTool = mainStack;
        SimpleContainer clawInventory = ClawInventoryData.getData(player).getContainer();
        for (int i = 1; i < ClawInventoryData.Slot.size(); ++i) {
            ItemStack breakingItem = clawInventory.getItem(i);
            if (breakingItem.isEmpty() || !breakingItem.isCorrectToolForDrops(state)) continue;
            float tempSpeed = breakingItem.getDestroySpeed(state);
            Item item = breakingItem.getItem();
            if (item instanceof DiggerItem) {
                DiggerItem item2 = (DiggerItem)item;
                tempSpeed = item2.getDestroySpeed(breakingItem, state);
            }
            if (!(tempSpeed > newSpeed)) continue;
            newSpeed = tempSpeed;
            harvestTool = breakingItem;
        }
        return harvestTool;
    }

    public static Pair<ItemStack, Integer> getDragonHarvestToolAndSlot(Player player, BlockState state) {
        ItemStack mainStack = player.getInventory().getSelected();
        float newSpeed = 0.0f;
        if (!ToolUtils.shouldUseDragonTools(mainStack)) {
            return Pair.of((Object)mainStack, (Object)-1);
        }
        ItemStack harvestTool = mainStack;
        int toolSlot = -1;
        SimpleContainer clawInventory = ClawInventoryData.getData(player).getContainer();
        for (int i = 0; i < ClawInventoryData.Slot.size(); ++i) {
            ItemStack breakingItem = clawInventory.getItem(i);
            if (breakingItem.isEmpty() || !breakingItem.isCorrectToolForDrops(state)) continue;
            float tempSpeed = breakingItem.getDestroySpeed(state);
            Item item = breakingItem.getItem();
            if (item instanceof DiggerItem) {
                DiggerItem item2 = (DiggerItem)item;
                tempSpeed = item2.getDestroySpeed(breakingItem, state);
            }
            if (!(tempSpeed > newSpeed)) continue;
            newSpeed = tempSpeed;
            harvestTool = breakingItem;
            toolSlot = i;
        }
        return Pair.of((Object)harvestTool, (Object)toolSlot);
    }

    public static ItemStack getDragonHarvestTool(Player player) {
        ItemStack mainStack = player.getInventory().getSelected();
        if (!ToolUtils.shouldUseDragonTools(mainStack)) {
            return mainStack;
        }
        Level world = player.level();
        BlockHitResult result = Item.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (result.getType() != HitResult.Type.MISS) {
            BlockState state = world.getBlockState(result.getBlockPos());
            return ClawToolHandler.getDragonHarvestTool(player, state);
        }
        return mainStack;
    }

    public static ItemStack getDragonSword(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return ItemStack.EMPTY;
        }
        Player player = (Player)entity;
        ItemStack itemInHand = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (!ToolUtils.shouldUseDragonTools(itemInHand)) {
            return ItemStack.EMPTY;
        }
        return ClawInventoryData.getData(player).getSword();
    }

    @SubscribeEvent
    public static void onToolBreak(PlayerDestroyItemEvent event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        Player player = event.getEntity();
        if (DragonStateProvider.isDragon((Entity)player)) {
            ItemStack clawTool = ClawToolHandler.getDragonHarvestTool(player);
            if (ItemStack.matches((ItemStack)clawTool, (ItemStack)event.getOriginal())) {
                clawTool.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)event.getHand()));
            } else if (!player.level().isClientSide()) {
                ClawInventoryData clawInventory = ClawInventoryData.getData(player);
                if (clawInventory.switchedTool) {
                    player.level().playSound(null, player.blockPosition(), SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SyncBrokenTool(player.getId(), clawInventory.switchedTool ? clawInventory.switchedToolSlot : ClawInventoryData.Slot.SWORD.ordinal()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void modifyBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.getEntity().getExistingData(DSDataAttachments.HARVEST_BONUSES).ifPresent(bonuses -> {
            float baseSpeed = bonuses.getBaseSpeed(event.getState());
            if (baseSpeed > event.getNewSpeed()) {
                event.setNewSpeed(baseSpeed);
            }
            event.setNewSpeed(event.getNewSpeed() * bonuses.getSpeedMultiplier(event.getState()));
        });
    }
}

