/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.blocks.SourceOfMagicBlock;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MovementData;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.SourceOfMagicBlockEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class SourceOfMagicHandler {
    @SubscribeEvent
    public static void handleTimer(PlayerTickEvent.Post event) {
        DragonStateHandler handler = DragonStateProvider.getData(event.getEntity());
        if (!handler.isDragon()) {
            return;
        }
        MovementData movement = MovementData.getData((Entity)event.getEntity());
        handler.isOnMagicSource = SourceOfMagicHandler.isOnMagicSource(event.getEntity(), handler);
        handler.magicSource = handler.isOnMagicSource && !movement.isMoving() && !movement.dig && !event.getEntity().isCrouching() ? ++handler.magicSource : 0;
    }

    private static boolean isOnMagicSource(Player player, DragonStateHandler handler) {
        SourceOfMagicBlockEntity source;
        BlockState state = player.getBlockStateOn();
        Block block = state.getBlock();
        if (!(block instanceof SourceOfMagicBlock)) {
            return false;
        }
        SourceOfMagicBlock sourceBlock = (SourceOfMagicBlock)block;
        if (!sourceBlock.isMagic(state)) {
            return false;
        }
        BlockEntity blockEntity = player.level().getBlockEntity(player.blockPosition());
        return blockEntity instanceof SourceOfMagicBlockEntity && (source = (SourceOfMagicBlockEntity)blockEntity).isApplicableFor(handler);
    }
}

