/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.server.containers.DragonContainer;
import by.dragonsurvivalteam.dragonsurvival.util.PotionUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public final class SortingHandler {
    private static final Comparator<ItemStack> FALLBACK_COMPARATOR = SortingHandler.jointComparator(Arrays.asList(Comparator.comparingInt(stack -> Item.getId((Item)stack.getItem())), SortingHandler::damageCompare, Comparator.comparingInt(ItemStack::getCount), Comparator.comparingInt(Object::hashCode), SortingHandler::fallbackNBTCompare));
    private static final Comparator<ItemStack> FOOD_COMPARATOR = SortingHandler.jointComparator(Arrays.asList(SortingHandler::foodNutritionCompare, SortingHandler::foodSaturationCompare));
    private static final Comparator<ItemStack> TOOL_COMPARATOR = SortingHandler.jointComparator(Arrays.asList(SortingHandler::toolPowerCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare));
    private static final Comparator<ItemStack> SWORD_COMPARATOR = SortingHandler.jointComparator(Arrays.asList(SortingHandler::swordPowerCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare));
    private static final Comparator<ItemStack> ARMOR_COMPARATOR = SortingHandler.jointComparator(Arrays.asList(SortingHandler::armorSlotAndToughnessCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare));
    private static final Comparator<ItemStack> BOW_COMPARATOR = SortingHandler.jointComparator(Arrays.asList(SortingHandler::enchantmentCompare, SortingHandler::damageCompare));
    private static final Comparator<ItemStack> POTION_COMPARATOR = SortingHandler.jointComparator(Arrays.asList(SortingHandler::potionComplexityCompare, SortingHandler::potionTypeCompare));

    public static void sortInventory(Player player) {
        if (player.containerMenu instanceof DragonContainer) {
            InvWrapper wrapper = new InvWrapper((Container)player.getInventory());
            SortingHandler.sortInventory((IItemHandler)wrapper, 9, 36);
        }
    }

    public static void sortInventory(IItemHandler handler, int start, int end) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> restore = new ArrayList<ItemStack>();
        for (int slot = start; slot < end; ++slot) {
            ItemStack stackAt = handler.getStackInSlot(slot);
            restore.add(stackAt.copy());
            if (stackAt.isEmpty()) continue;
            stacks.add(stackAt.copy());
        }
        SortingHandler.mergeStacks(stacks);
        SortingHandler.sortStackList(stacks);
        if (SortingHandler.setInventory(handler, stacks, start, end) == InteractionResult.FAIL) {
            SortingHandler.setInventory(handler, restore, start, end);
        }
    }

    private static InteractionResult setInventory(IItemHandler inventory, List<ItemStack> stacks, int start, int end) {
        ItemStack stack;
        int index;
        int slot;
        for (slot = start; slot < end; ++slot) {
            ItemStack extractTest;
            index = slot - start;
            stack = index >= stacks.size() ? ItemStack.EMPTY : stacks.get(index);
            ItemStack stackInSlot = inventory.getStackInSlot(slot);
            if (!stackInSlot.isEmpty() && ((extractTest = inventory.extractItem(slot, inventory.getSlotLimit(slot), true)).isEmpty() || extractTest.getCount() != stackInSlot.getCount())) {
                return InteractionResult.PASS;
            }
            if (stack.isEmpty() || inventory.isItemValid(slot, stack)) continue;
            return InteractionResult.PASS;
        }
        for (slot = start; slot < end; ++slot) {
            inventory.extractItem(slot, inventory.getSlotLimit(slot), false);
        }
        for (slot = start; slot < end && (index = slot - start) < stacks.size(); ++slot) {
            stack = stacks.get(index);
            if (stack.isEmpty() || inventory.insertItem(slot, stack, false).isEmpty()) continue;
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public static void mergeStacks(List<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack set = SortingHandler.mergeStackWithOthers(list, i);
            list.set(i, set);
        }
        list.removeIf(stack -> stack.isEmpty() || stack.getCount() == 0);
    }

    private static ItemStack mergeStackWithOthers(List<ItemStack> list, int index) {
        ItemStack stack = list.get(index);
        if (stack.isEmpty()) {
            return stack;
        }
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stackAt;
            if (i == index || (stackAt = list.get(i)).isEmpty() || stackAt.getCount() >= stackAt.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stackAt)) continue;
            int setSize = stackAt.getCount() + stack.getCount();
            int carryover = Math.max(0, setSize - stackAt.getMaxStackSize());
            stackAt.setCount(carryover);
            stack.setCount(setSize - carryover);
            if (stack.getCount() != stack.getMaxStackSize()) continue;
            return stack;
        }
        return stack;
    }

    public static void sortStackList(List<ItemStack> list) {
        list.sort(SortingHandler::stackCompare);
    }

    private static int stackCompare(ItemStack first, ItemStack second) {
        ItemType secondType;
        if (first == second) {
            return 0;
        }
        if (first.isEmpty()) {
            return -1;
        }
        if (second.isEmpty()) {
            return 1;
        }
        ItemType firstType = SortingHandler.getType(first);
        if (firstType == (secondType = SortingHandler.getType(second))) {
            return firstType.comparator.compare(first, second);
        }
        return firstType.ordinal() - secondType.ordinal();
    }

    private static ItemType getType(ItemStack stack) {
        for (ItemType type : ItemType.values()) {
            if (!type.fitsInType(stack)) continue;
            return type;
        }
        throw new RuntimeException("Having an ItemStack that doesn't fit in any type is impossible.");
    }

    private static Predicate<ItemStack> classPredicate(Class<? extends Item> type) {
        return stack -> !stack.isEmpty() && type.isInstance(stack.getItem());
    }

    private static Predicate<ItemStack> inverseClassPredicate(Class<? extends Item> type) {
        return SortingHandler.classPredicate(type).negate();
    }

    private static Predicate<ItemStack> itemPredicate(List<Item> list) {
        return s -> !s.isEmpty() && list.contains(s.getItem());
    }

    public static Comparator<ItemStack> jointComparator(Comparator<ItemStack> finalComparator, List<Comparator<ItemStack>> otherComparators) {
        if (otherComparators == null) {
            return SortingHandler.jointComparator(List.of(finalComparator));
        }
        ArrayList<Comparator<ItemStack>> newList = new ArrayList<Comparator<ItemStack>>(otherComparators);
        newList.add(finalComparator);
        return SortingHandler.jointComparator(newList);
    }

    public static Comparator<ItemStack> jointComparator(List<Comparator<ItemStack>> comparators) {
        return SortingHandler.jointComparatorFallback((first, second) -> {
            for (Comparator comparator : comparators) {
                int compare;
                if (comparator == null || (compare = comparator.compare(first, second)) == 0) continue;
                return compare;
            }
            return 0;
        }, FALLBACK_COMPARATOR);
    }

    private static Comparator<ItemStack> jointComparatorFallback(Comparator<ItemStack> comparator, Comparator<ItemStack> fallback) {
        return (first, second) -> {
            int compare = comparator.compare((ItemStack)first, (ItemStack)second);
            if (compare == 0) {
                return fallback == null ? 0 : fallback.compare((ItemStack)first, (ItemStack)second);
            }
            return compare;
        };
    }

    private static Comparator<ItemStack> listOrderComparator(List<Item> list) {
        return (first, second) -> {
            Item firstItem = first.getItem();
            Item secondItem = second.getItem();
            if (list.contains(firstItem)) {
                if (list.contains(secondItem)) {
                    return list.indexOf(firstItem) - list.indexOf(secondItem);
                }
                return 1;
            }
            if (list.contains(secondItem)) {
                return -1;
            }
            return 0;
        };
    }

    private static List<Item> list(Object ... items) {
        ArrayList<Item> list = new ArrayList<Item>();
        block6: for (Object object : items) {
            Object object2;
            Objects.requireNonNull(object);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Item.class, Block.class, ItemStack.class, String.class}, (Object)object2, n)) {
                case 0: {
                    Item item = (Item)object2;
                    list.add(item);
                    continue block6;
                }
                case 1: {
                    Block block = (Block)object2;
                    list.add(block.asItem());
                    continue block6;
                }
                case 2: {
                    ItemStack stack = (ItemStack)object2;
                    list.add(stack.getItem());
                    continue block6;
                }
                case 3: {
                    String string = (String)object2;
                    Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)string));
                    if (item == Items.AIR) continue block6;
                    list.add(item);
                    continue block6;
                }
            }
        }
        return list;
    }

    private static int nutrition(FoodProperties properties) {
        if (properties == null) {
            return 0;
        }
        return properties.nutrition();
    }

    private static int foodNutritionCompare(ItemStack first, ItemStack second) {
        return SortingHandler.nutrition(second.getFoodProperties(null)) - SortingHandler.nutrition(first.getFoodProperties(null));
    }

    private static float saturation(FoodProperties properties) {
        if (properties == null) {
            return 0.0f;
        }
        return properties.saturation();
    }

    private static int foodSaturationCompare(ItemStack first, ItemStack second) {
        float result = SortingHandler.saturation(second.getFoodProperties(null)) - SortingHandler.saturation(first.getFoodProperties(null));
        if (result < 0.0f) {
            return 1;
        }
        if (result > 0.0f) {
            return -1;
        }
        return 0;
    }

    private static int enchantmentCompare(ItemStack first, ItemStack second) {
        return SortingHandler.enchantmentPower(second) - SortingHandler.enchantmentPower(first);
    }

    private static int enchantmentPower(ItemStack stack) {
        if (!stack.isEnchanted()) {
            return 0;
        }
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        int total = 0;
        for (Object2IntMap.Entry entry : enchantments.entrySet()) {
            total += entry.getIntValue();
        }
        return total;
    }

    private static int toolPowerCompare(ItemStack first, ItemStack second) {
        Tier firstTier = ((DiggerItem)first.getItem()).getTier();
        Tier secondTier = ((DiggerItem)second.getItem()).getTier();
        return (int)(secondTier.getSpeed() * 100.0f - firstTier.getSpeed() * 100.0f);
    }

    private static int swordPowerCompare(ItemStack first, ItemStack second) {
        Tier firstTier = ((SwordItem)first.getItem()).getTier();
        Tier secondTier = ((SwordItem)second.getItem()).getTier();
        return (int)(secondTier.getAttackDamageBonus() * 100.0f - firstTier.getAttackDamageBonus() * 100.0f);
    }

    private static int armorSlotAndToughnessCompare(ItemStack first, ItemStack second) {
        EquipmentSlot secondSlot;
        ArmorItem firstArmor = (ArmorItem)first.getItem();
        ArmorItem secondArmor = (ArmorItem)second.getItem();
        EquipmentSlot firstSlot = firstArmor.getEquipmentSlot();
        if (firstSlot == (secondSlot = secondArmor.getEquipmentSlot())) {
            double firstDefense = (float)((ArmorMaterial)firstArmor.getMaterial().value()).getDefense(firstArmor.getType()) * (1.0f + firstArmor.getToughness());
            double secondDefense = (float)((ArmorMaterial)secondArmor.getMaterial().value()).getDefense(secondArmor.getType()) * (1.0f + secondArmor.getToughness());
            double result = secondDefense - firstDefense;
            if (result < 0.0) {
                return 1;
            }
            if (result > 0.0) {
                return -1;
            }
            return 0;
        }
        return secondSlot.getIndex() - firstSlot.getIndex();
    }

    public static int damageCompare(ItemStack stack1, ItemStack stack2) {
        return stack1.getDamageValue() - stack2.getDamageValue();
    }

    public static int fallbackNBTCompare(ItemStack first, ItemStack second) {
        CompoundTag secondTag;
        if (ItemStack.isSameItemSameComponents((ItemStack)first, (ItemStack)second)) {
            return 0;
        }
        CustomData firstData = (CustomData)first.get(DataComponents.CUSTOM_DATA);
        CustomData secondData = (CustomData)second.get(DataComponents.CUSTOM_DATA);
        if (firstData != null && secondData == null) {
            return 1;
        }
        if (firstData == null && secondData != null) {
            return -1;
        }
        if (firstData == null) {
            return 0;
        }
        CompoundTag firstTag = firstData.getUnsafe();
        if (NbtUtils.compareNbt((Tag)firstTag, (Tag)(secondTag = secondData.getUnsafe()), (boolean)true)) {
            return 0;
        }
        return Comparator.comparingInt(CompoundTag::size).compare(firstTag, secondTag);
    }

    public static int potionComplexityCompare(ItemStack first, ItemStack second) {
        List firstEffects = PotionUtils.getPotion(first).map(Potion::getEffects).orElse(Collections.emptyList());
        List secondEffects = PotionUtils.getPotion(second).map(Potion::getEffects).orElse(Collections.emptyList());
        int firstTotal = 0;
        int secondTotal = 0;
        for (MobEffectInstance inst : firstEffects) {
            firstTotal += inst.getAmplifier() * inst.getDuration();
        }
        for (MobEffectInstance inst : secondEffects) {
            secondTotal += inst.getAmplifier() * inst.getDuration();
        }
        return secondTotal - firstTotal;
    }

    public static int potionTypeCompare(ItemStack first, ItemStack second) {
        Potion firstPotion = PotionUtils.getPotion(first).orElse(null);
        Potion secondPotion = PotionUtils.getPotion(second).orElse(null);
        if (firstPotion == null) {
            return secondPotion == null ? 0 : 1;
        }
        if (secondPotion == null) {
            return -1;
        }
        return BuiltInRegistries.POTION.getId((Object)secondPotion) - BuiltInRegistries.POTION.getId((Object)firstPotion);
    }

    private static enum ItemType {
        FOOD(stack -> stack.getFoodProperties(null) != null, FOOD_COMPARATOR),
        TORCH(SortingHandler.list(Blocks.TORCH)),
        TOOL_PICKAXE(SortingHandler.classPredicate(PickaxeItem.class), TOOL_COMPARATOR),
        TOOL_SHOVEL(SortingHandler.classPredicate(ShovelItem.class), TOOL_COMPARATOR),
        TOOL_AXE(SortingHandler.classPredicate(AxeItem.class), TOOL_COMPARATOR),
        TOOL_SWORD(SortingHandler.classPredicate(SwordItem.class), SWORD_COMPARATOR),
        TOOL_GENERIC(SortingHandler.classPredicate(DiggerItem.class), TOOL_COMPARATOR),
        ARMOR(SortingHandler.classPredicate(ArmorItem.class), ARMOR_COMPARATOR),
        BOW(SortingHandler.classPredicate(BowItem.class), BOW_COMPARATOR),
        CROSSBOW(SortingHandler.classPredicate(CrossbowItem.class), BOW_COMPARATOR),
        TRIDENT(SortingHandler.classPredicate(TridentItem.class), BOW_COMPARATOR),
        ARROWS(SortingHandler.classPredicate(ArrowItem.class)),
        POTION(SortingHandler.classPredicate(PotionItem.class), POTION_COMPARATOR),
        TIPPED_ARROW(SortingHandler.classPredicate(TippedArrowItem.class), POTION_COMPARATOR),
        MINECART(SortingHandler.classPredicate(MinecartItem.class)),
        RAIL(SortingHandler.list(Blocks.RAIL, Blocks.POWERED_RAIL, Blocks.DETECTOR_RAIL, Blocks.ACTIVATOR_RAIL)),
        DYE(SortingHandler.classPredicate(DyeItem.class)),
        ANY(SortingHandler.inverseClassPredicate(BlockItem.class)),
        BLOCK(SortingHandler.classPredicate(BlockItem.class));

        private final Predicate<ItemStack> predicate;
        private final Comparator<ItemStack> comparator;

        private ItemType(List<Item> list) {
            this(SortingHandler.itemPredicate(list), SortingHandler.jointComparator(SortingHandler.listOrderComparator(list), new ArrayList<Comparator<ItemStack>>()));
        }

        private ItemType(Predicate<ItemStack> predicate) {
            this(predicate, FALLBACK_COMPARATOR);
        }

        private ItemType(Predicate<ItemStack> predicate, Comparator<ItemStack> comparator) {
            this.predicate = predicate;
            this.comparator = comparator;
        }

        public boolean fitsInType(ItemStack stack) {
            return this.predicate.test(stack);
        }
    }
}

