/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEnchantments;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSDamageTypeTags;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSEffectTags;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.util.EnchantmentUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ArrowLooseEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class EnchantmentEffectHandler {
    @SubscribeEvent
    public static void fireCrossbow(ArrowLooseEvent event) {
        ChargedProjectiles charged;
        if (!(event.getBow().getItem() instanceof CrossbowItem)) {
            return;
        }
        if (EnchantmentUtils.getLevel(event.getLevel(), DSEnchantments.BOLAS, event.getBow()) > 0 && (charged = (ChargedProjectiles)event.getBow().get(DataComponents.CHARGED_PROJECTILES)) != null) {
            List ammo = charged.getItems();
            ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ammo) {
                projectiles.add(itemStack.getItem() instanceof ArrowItem ? new ItemStack((ItemLike)DSItems.BOLAS.value()) : itemStack);
            }
            event.getBow().set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(projectiles));
        }
    }

    @SubscribeEvent
    public static void handleDragonsbaneEnchantment(LivingDeathEvent event) {
        Player victim;
        LivingEntity livingEntity;
        block9: {
            block8: {
                livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block8;
                victim = (Player)livingEntity;
                livingEntity = event.getSource().getEntity();
                if (livingEntity instanceof Player) break block9;
            }
            return;
        }
        Player attacker = (Player)livingEntity;
        if (!victim.hasEffect(DSEffects.HUNTER_OMEN)) {
            return;
        }
        ItemStack weapon = event.getSource().getWeaponItem();
        if (weapon == null) {
            return;
        }
        int enchantmentLevel = EnchantmentUtils.getLevel(attacker.level(), DSEnchantments.DRAGONSBANE, weapon);
        if (enchantmentLevel > 0) {
            DragonStateHandler victimData = DragonStateProvider.getData(victim);
            if (!victimData.isDragon()) {
                return;
            }
            victimData.setDesiredGrowth(victim, victimData.getGrowth() - EnchantmentEffectHandler.getStolenTime(victimData) * (double)enchantmentLevel);
            DragonStateHandler attackerData = DragonStateProvider.getData(attacker);
            if (attackerData.isDragon()) {
                attackerData.setDesiredGrowth(attacker, attackerData.getGrowth() + EnchantmentEffectHandler.getStolenTime(attackerData));
            }
            attacker.level().playLocalSound(attacker.blockPosition(), SoundEvents.AMBIENT_UNDERWATER_LOOP_ADDITIONS_ULTRA_RARE, SoundSource.PLAYERS, 2.0f, 1.0f, false);
        }
    }

    public static MobEffectInstance modifyEffect(Player affected, MobEffectInstance instance, @Nullable Entity applier) {
        if (instance == null || Objects.equals(affected, applier)) {
            return instance;
        }
        int amplifier = instance.getAmplifier();
        if (((MobEffect)instance.getEffect().value()).getCategory().equals((Object)MobEffectCategory.HARMFUL)) {
            if (applier instanceof LivingEntity) {
                LivingEntity livingApplier = (LivingEntity)applier;
                if (!instance.getEffect().is(DSEffectTags.OVERWHELMING_MIGHT_BLACKLIST)) {
                    amplifier += EnchantmentUtils.getLevel(livingApplier, DSEnchantments.OVERWHELMING_MIGHT);
                }
            }
            if (!instance.getEffect().is(DSEffectTags.UNBREAKABLE_SPIRIT_BLACKLIST)) {
                amplifier -= EnchantmentUtils.getLevel((LivingEntity)affected, DSEnchantments.UNBREAKABLE_SPIRIT);
            }
            if ((amplifier = Mth.clamp((int)amplifier, (int)0, (int)255)) != instance.getAmplifier()) {
                MobEffectInstance modifiedInstance = new MobEffectInstance(instance.getEffect(), instance.getDuration(), amplifier, instance.isAmbient(), instance.isVisible(), instance.showIcon());
                if (affected.hasEffect(instance.getEffect())) {
                    affected.removeEffect(instance.getEffect());
                }
                return modifiedInstance;
            }
        }
        return instance;
    }

    @SubscribeEvent
    public static void livingHurt(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof LivingEntity) {
            LivingEntity target = livingEntity;
            livingEntity = event.getSource().getEntity();
            if (livingEntity instanceof LivingEntity) {
                AttributeInstance armorIgnoreChance;
                int level;
                int level2;
                LivingEntity attacker = livingEntity;
                MobEffectInstance siphon = target.getEffect(DSEffects.BLOOD_SIPHON);
                if (siphon != null) {
                    float percentage = 0.01f * (float)(siphon.getAmplifier() + 1);
                    attacker.heal(event.getAmount() * percentage);
                }
                if (event.getSource().is(DSDamageTypeTags.DRAGON_MAGIC) && (level2 = EnchantmentUtils.getLevel(attacker, DSEnchantments.DRACONIC_SUPERIORITY)) > 0) {
                    event.setAmount(event.getAmount() * 1.2f + 0.08f * (float)level2);
                }
                if (event.getEntity().getHealth() == event.getEntity().getMaxHealth() && (level = EnchantmentUtils.getLevel(attacker, DSEnchantments.MURDERERS_CUNNING)) > 0) {
                    event.setAmount(event.getAmount() * 1.4f + 0.2f * (float)level);
                }
                if ((armorIgnoreChance = attacker.getAttribute(DSAttributes.ARMOR_IGNORE_CHANCE)) != null && target.getRandom().nextDouble() < armorIgnoreChance.getValue()) {
                    event.addReductionModifier(DamageContainer.Reduction.ARMOR, (container, reductionIn) -> 0.0f);
                }
            }
        }
    }

    private static double getStolenTime(DragonStateHandler handler) {
        int ticksToSteal = Functions.minutesToTicks(30.0);
        DragonStage level = (DragonStage)handler.stage().value();
        return level.ticksToGrowth(ticksToSteal);
    }
}

