/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.PenaltySupply;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.HitByProjectileTrigger;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.ItemUsedTrigger;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.PenaltyTrigger;
import by.dragonsurvivalteam.dragonsurvival.server.containers.slots.ClawToolSlot;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ItemStackedOnOtherEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class DragonPenaltyHandler {
    @SubscribeEvent
    public static void applyPenalties(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (serverPlayer.isSpectator() || serverPlayer.isCreative()) {
            return;
        }
        DragonStateHandler handler = DragonStateProvider.getData((Player)serverPlayer);
        if (!handler.isDragon()) {
            PenaltySupply.clear((Player)serverPlayer);
            return;
        }
        for (Holder penalty : ((DragonSpecies)handler.species().value()).penalties()) {
            if (((DragonPenalty)penalty.value()).trigger().hasCustomTrigger()) continue;
            ((DragonPenalty)penalty.value()).apply(serverPlayer, (Holder<DragonPenalty>)penalty);
        }
    }

    @SubscribeEvent
    public static void applyItemConsumedPenalties(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        DragonStateHandler handler = DragonStateProvider.getData((Player)serverPlayer);
        if (!handler.isDragon()) {
            return;
        }
        for (Holder penalty : ((DragonSpecies)handler.species().value()).penalties()) {
            ItemUsedTrigger trigger;
            PenaltyTrigger penaltyTrigger = ((DragonPenalty)penalty.value()).trigger();
            if (!(penaltyTrigger instanceof ItemUsedTrigger) || !(trigger = (ItemUsedTrigger)penaltyTrigger).test(event.getItem())) continue;
            ((DragonPenalty)penalty.value()).apply(serverPlayer, (Holder<DragonPenalty>)penalty);
        }
    }

    @SubscribeEvent
    public static void applyHitByProjectilePenalties(ProjectileImpactEvent event) {
        EntityHitResult hitResult;
        HitResult hitResult2 = event.getRayTraceResult();
        if (!(hitResult2 instanceof EntityHitResult) || !((hitResult2 = (hitResult = (EntityHitResult)hitResult2).getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)hitResult2;
        DragonStateHandler handler = DragonStateProvider.getData((Player)serverPlayer);
        if (!handler.isDragon()) {
            return;
        }
        for (Holder penalty : ((DragonSpecies)handler.species().value()).penalties()) {
            PenaltyTrigger penaltyTrigger = ((DragonPenalty)penalty.value()).trigger();
            if (!(penaltyTrigger instanceof HitByProjectileTrigger)) continue;
            HitByProjectileTrigger trigger = (HitByProjectileTrigger)penaltyTrigger;
            if (!event.getProjectile().getType().is(trigger.projectiles())) continue;
            ((DragonPenalty)penalty.value()).apply(serverPlayer, (Holder<DragonPenalty>)penalty);
        }
    }

    @SubscribeEvent
    public static void preventEquipment(ItemStackedOnOtherEvent event) {
        ItemStack stack = event.getStackedOnItem();
        Player player = event.getPlayer();
        if (stack.isEmpty()) {
            return;
        }
        if (!(event.getSlot() instanceof ArmorSlot) && !(event.getSlot() instanceof ClawToolSlot)) {
            return;
        }
        DragonStateHandler data = DragonStateProvider.getData(player);
        if (data.isDragon() && ((DragonSpecies)data.species().value()).isItemBlacklisted(stack.getItem())) {
            event.setCanceled(true);
        }
    }
}

