/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.creatures;

import by.dragonsurvivalteam.dragonsurvival.client.render.util.RandomAnimationPicker;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.Hunter;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.KnightEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.goals.FollowSpecificMobGoal;
import by.dragonsurvivalteam.dragonsurvival.common.entity.goals.WindupMeleeAttackGoal;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.util.AnimationUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class SpearmanEntity
extends Hunter {
    @ConfigRange(min=1.0)
    @Translation(key="spearman_health", type=Translation.Type.CONFIGURATION, comments={"Base value for the max health attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "spearman"}, key="spearman_health")
    public static double MAX_HEALTH = 24.0;
    @ConfigRange(min=0.0)
    @Translation(key="spearman_attack_damage", type=Translation.Type.CONFIGURATION, comments={"Base value for the attack damage attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "spearman"}, key="spearman_damage")
    public static int ATTACK_DAMAGE = 6;
    @ConfigRange(min=0.0)
    @Translation(key="spearman_attack_knockback", type=Translation.Type.CONFIGURATION, comments={"Base value for the attack knockback attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "spearman"}, key="spearman_attack_knockback")
    public static int ATTACK_KNOCKBACK = 0;
    @ConfigRange(min=0.0)
    @Translation(key="spearman_movement_speed", type=Translation.Type.CONFIGURATION, comments={"Base value for the movement speed attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "spearman"}, key="spearman_movement_speed")
    public static double MOVEMENT_SPEED = 0.35;
    @ConfigRange(min=0.0)
    @Translation(key="spearman_armor", type=Translation.Type.CONFIGURATION, comments={"Base value for the armor attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "spearman"}, key="spearman_armor")
    public static double ARMOR = 2.0;
    @ConfigRange(min=0.0)
    @Translation(key="spearman_armor_toughness", type=Translation.Type.CONFIGURATION, comments={"Base value for the armor toughness attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "spearman"}, key="spearman_armor_toughness")
    public static double ARMOR_TOUGHNESS = 0.0;
    @ConfigRange(min=0.0)
    @Translation(key="spearman_knockback_resistance", type=Translation.Type.CONFIGURATION, comments={"Base value for the knockback resistance attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "spearman"}, key="spearman_knockback_resistance")
    public static double KNOCKBACK_RESISTANCE = 0.0;
    @ConfigRange(min=0.0, max=256.0)
    @Translation(key="spearman_bonus_horizontal_reach", type=Translation.Type.CONFIGURATION, comments={"Additional horizontal reach for the spearman"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "spearman"}, key="spearman_bonus_horizontal_reach")
    public static double HORIZONTAL_REACH = 0.5;
    @ConfigRange(min=0.0, max=256.0)
    @Translation(key="spearman_bonus_vertical_reach", type=Translation.Type.CONFIGURATION, comments={"Additional vertical reach for the spearman"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "spearman"}, key="spearman_bonus_vertical_reach")
    public static double VERTICAL_REACH = 2.5;
    private RawAnimation currentIdleAnim;
    private boolean isIdleAnimSet = false;
    private static final RandomAnimationPicker IDLE_ANIMS = new RandomAnimationPicker(new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("idle1"), 90.0f), new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("idle2"), 9.0f), new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("idle3"), 1.0f));
    private static final RawAnimation WALK_BLEND = RawAnimation.begin().thenLoop("blend_walk");
    private static final RawAnimation RUN_BLEND = RawAnimation.begin().thenLoop("blend_run");
    private static final RawAnimation IDLE_BLEND = RawAnimation.begin().thenLoop("blend_idle");
    private static final RawAnimation WALK_ARMS_BLEND = RawAnimation.begin().thenLoop("blend_walk_arms");
    private static final RawAnimation ATTACK_BLEND = RawAnimation.begin().thenLoop("blend_attack");
    private static final RawAnimation AGGRO_BLEND = RawAnimation.begin().thenLoop("blend_aggro");
    private static final RawAnimation HEAD_BLEND = RawAnimation.begin().thenLoop("blend_head");

    @Override
    public double maxHealthConfig() {
        return MAX_HEALTH;
    }

    @Override
    public double attackDamageConfig() {
        return ATTACK_DAMAGE;
    }

    @Override
    public double attackKnockback() {
        return ATTACK_KNOCKBACK;
    }

    @Override
    public double movementSpeedConfig() {
        return MOVEMENT_SPEED;
    }

    @Override
    public double armorConfig() {
        return ARMOR;
    }

    @Override
    public double armorToughnessConfig() {
        return ARMOR_TOUGHNESS;
    }

    @Override
    public double knockbackResistanceConfig() {
        return KNOCKBACK_RESISTANCE;
    }

    public SpearmanEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new WindupMeleeAttackGoal(this, 1.0, 13));
        this.goalSelector.addGoal(8, (Goal)new FollowSpecificMobGoal((Mob)this, 0.6, 10.0f, 20.0f, target -> target instanceof KnightEntity));
    }

    public double getRunThreshold() {
        return 0.15;
    }

    public double getWalkThreshold() {
        return 0.01;
    }

    public boolean isWithinMeleeAttackRange(LivingEntity pEntity) {
        return this.getAttackBoundingBox().inflate(HORIZONTAL_REACH, VERTICAL_REACH, HORIZONTAL_REACH).intersects(pEntity.getHitbox());
    }

    public int getCurrentSwingDuration() {
        return 17;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "everything", 3, this::fullPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "head", 3, this::headPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "arms", 3, this::armsPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "legs", 3, this::legsPredicate));
    }

    @NotNull
    public InteractionResult mobInteract(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (!this.isAlive()) {
            return super.mobInteract(pPlayer, pHand);
        }
        if (itemstack.getItem() == DSItems.SPEARMAN_PROMOTION.value()) {
            if (!this.level().isClientSide) {
                Mob leader = (Mob)((EntityType)DSEntities.HUNTER_LEADER.get()).create(this.level());
                leader.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
                leader.finalizeSpawn((ServerLevelAccessor)((ServerLevel)this.level()), this.level().getCurrentDifficultyAt(leader.blockPosition()), MobSpawnType.CONVERSION, null);
                leader.setNoAi(this.isNoAi());
                if (this.hasCustomName()) {
                    leader.setCustomName(this.getCustomName());
                    leader.setCustomNameVisible(this.isCustomNameVisible());
                }
                leader.setPersistenceRequired();
                EventHooks.onLivingConvert((LivingEntity)this, (LivingEntity)leader);
                this.level().addFreshEntity((Entity)leader);
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.AMETHYST_BLOCK_CHIME, this.getSoundSource(), 2.0f, 1.0f);
                this.discard();
            }
            for (int i = 0; i < 20; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getX() + (this.random.nextDouble() - 0.5) * 2.0, this.getY() + this.random.nextDouble() * 2.0, this.getZ() + (this.random.nextDouble() - 0.5) * 2.0, (this.random.nextDouble() - 0.5) * 0.5, this.random.nextDouble() * 0.5, (this.random.nextDouble() - 0.5) * 0.5);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(pPlayer, pHand);
    }

    private boolean isNotIdle() {
        double movement = AnimationUtils.getMovementSpeed((LivingEntity)this);
        return this.swingTime > 0 || movement > this.getWalkThreshold() || this.isAggro();
    }

    public PlayState fullPredicate(AnimationState<SpearmanEntity> state) {
        if (this.isNotIdle()) {
            this.isIdleAnimSet = false;
            return PlayState.STOP;
        }
        return state.setAndContinue(this.getIdleAnim());
    }

    public PlayState headPredicate(AnimationState<SpearmanEntity> state) {
        return state.setAndContinue(HEAD_BLEND);
    }

    public PlayState armsPredicate(AnimationState<SpearmanEntity> state) {
        if (this.swingTime > 0) {
            return state.setAndContinue(ATTACK_BLEND);
        }
        if (this.isAggro()) {
            return state.setAndContinue(AGGRO_BLEND);
        }
        if (this.isNotIdle()) {
            return state.setAndContinue(WALK_ARMS_BLEND);
        }
        return PlayState.STOP;
    }

    public PlayState legsPredicate(AnimationState<SpearmanEntity> state) {
        double movement = AnimationUtils.getMovementSpeed((LivingEntity)this);
        if (movement > this.getRunThreshold()) {
            return state.setAndContinue(RUN_BLEND);
        }
        if (movement > this.getWalkThreshold()) {
            return state.setAndContinue(WALK_BLEND);
        }
        if (this.isAggro()) {
            return state.setAndContinue(IDLE_BLEND);
        }
        return PlayState.STOP;
    }

    public RawAnimation getIdleAnim() {
        if (!this.isIdleAnimSet) {
            this.currentIdleAnim = IDLE_ANIMS.pickRandomAnimation();
            this.isIdleAnimSet = true;
        }
        return this.currentIdleAnim;
    }
}

