/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.creatures;

import by.dragonsurvivalteam.dragonsurvival.client.render.util.RandomAnimationPicker;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.ConfigurableAttributes;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.DSTrades;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.util.AnimationUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LeaderEntity
extends Villager
implements GeoEntity,
ConfigurableAttributes {
    @ConfigRange(min=1.0)
    @Translation(key="leader_health", type=Translation.Type.CONFIGURATION, comments={"Base value for the max health attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "leader"}, key="leader_health")
    public static double MAX_HEALTH = 24.0;
    @ConfigRange(min=0.0)
    @Translation(key="leader_movement_speed", type=Translation.Type.CONFIGURATION, comments={"Base value for the movement speed attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "leader"}, key="leader_movement_speed")
    public static double MOVEMENT_SPEED = 0.35;
    @ConfigRange(min=0.0)
    @Translation(key="leader_armor", type=Translation.Type.CONFIGURATION, comments={"Base value for the armor attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "leader"}, key="leader_armor")
    public static double ARMOR = 0.0;
    @ConfigRange(min=0.0)
    @Translation(key="leader_armor_toughness", type=Translation.Type.CONFIGURATION, comments={"Base value for the armor toughness attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "leader"}, key="leader_armor_toughness")
    public static double ARMOR_TOUGHNESS = 0.0;
    @ConfigRange(min=0.0)
    @Translation(key="leader_knockback_resistance", type=Translation.Type.CONFIGURATION, comments={"Base value for the knockback resistance attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "leader"}, key="leader_knockback_resistance")
    public static double KNOCKBACK_RESISTANCE = 0.0;
    private static final EntityDataAccessor<Integer> RESTOCK_TIMER = SynchedEntityData.defineId(LeaderEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int TOTAL_RESTOCK_TIME = Functions.minutesToTicks(10.0);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private RawAnimation currentIdleAnim;
    private boolean isIdleAnimSet;
    private boolean initializedAttributes;
    private static final RandomAnimationPicker IDLE_ANIMS = new RandomAnimationPicker(new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("idle1"), 69.0f), new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("idle2"), 20.0f), new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("idle3"), 10.0f), new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("idle4"), 1.0f));
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("run");
    private static final RawAnimation ATTACK_BLEND = RawAnimation.begin().thenLoop("blend_attack");
    private static final RawAnimation HEAD_BLEND = RawAnimation.begin().thenLoop("blend_head");

    @Override
    public double maxHealthConfig() {
        return MAX_HEALTH;
    }

    @Override
    public double movementSpeedConfig() {
        return MOVEMENT_SPEED;
    }

    @Override
    public double armorConfig() {
        return ARMOR;
    }

    @Override
    public double armorToughnessConfig() {
        return ARMOR_TOUGHNESS;
    }

    @Override
    public double knockbackResistanceConfig() {
        return KNOCKBACK_RESISTANCE;
    }

    public LeaderEntity(EntityType<? extends Villager> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "everything", 3, this::fullPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "head", 3, this::headPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "arms", 3, this::armsPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "legs", 3, this::legsPredicate));
    }

    private double getWalkThreshold() {
        return 0.01;
    }

    private double getRunThreshold() {
        return 0.15;
    }

    private boolean isNotIdle() {
        double movement = AnimationUtils.getMovementSpeed((LivingEntity)this);
        return this.swingTime > 0 || movement > this.getWalkThreshold();
    }

    public PlayState fullPredicate(AnimationState<LeaderEntity> state) {
        if (this.isNotIdle()) {
            this.isIdleAnimSet = false;
            return PlayState.STOP;
        }
        return state.setAndContinue(this.getIdleAnim());
    }

    public PlayState headPredicate(AnimationState<LeaderEntity> state) {
        return state.setAndContinue(HEAD_BLEND);
    }

    public PlayState armsPredicate(AnimationState<LeaderEntity> state) {
        if (this.swingTime > 0) {
            return state.setAndContinue(ATTACK_BLEND);
        }
        return PlayState.STOP;
    }

    public PlayState legsPredicate(AnimationState<LeaderEntity> state) {
        double movement = AnimationUtils.getMovementSpeed((LivingEntity)this);
        if (movement > this.getRunThreshold()) {
            return state.setAndContinue(RUN);
        }
        if (movement > this.getWalkThreshold()) {
            return state.setAndContinue(WALK);
        }
        return PlayState.STOP;
    }

    public RawAnimation getIdleAnim() {
        if (!this.isIdleAnimSet) {
            this.currentIdleAnim = IDLE_ANIMS.pickRandomAnimation();
            this.isIdleAnimSet = true;
        }
        return this.currentIdleAnim;
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RESTOCK_TIMER, (Object)TOTAL_RESTOCK_TIME);
    }

    private void setRestockTimer(int time) {
        this.entityData.set(RESTOCK_TIMER, (Object)time);
    }

    private int getRestockTimer() {
        return (Integer)this.entityData.get(RESTOCK_TIMER);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compoundNBT) {
        super.addAdditionalSaveData(compoundNBT);
        compoundNBT.putInt("RestockTimer", this.getRestockTimer());
        compoundNBT.putBoolean("initialized_attributes", this.initializedAttributes);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compoundNBT) {
        super.readAdditionalSaveData(compoundNBT);
        this.setRestockTimer(compoundNBT.getInt("RestockTimer"));
        this.initializedAttributes = compoundNBT.getBoolean("initialized_attributes");
    }

    public void tick() {
        if (!this.initializedAttributes) {
            this.setAttributes();
            this.initializedAttributes = true;
        }
        super.tick();
        if (this.level() instanceof ServerLevel) {
            if (this.getRestockTimer() > 0) {
                this.setRestockTimer(this.getRestockTimer() - 1);
            } else {
                this.restock();
                this.setRestockTimer(TOTAL_RESTOCK_TIME);
            }
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public SoundEvent getNotifyTradeSound() {
        return SoundEvents.VILLAGER_YES;
    }

    @NotNull
    protected SoundEvent getTradeUpdatedSound(boolean pIsYesSound) {
        return pIsYesSound ? SoundEvents.VILLAGER_YES : SoundEvents.VILLAGER_NO;
    }

    public void playCelebrateSound() {
    }

    @NotNull
    protected Brain<?> makeBrain(@NotNull Dynamic<?> pDynamic) {
        return this.brainProvider().makeBrain(pDynamic);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return SoundEvents.VILLAGER_HURT;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return SoundEvents.VILLAGER_DEATH;
    }

    public void playWorkSound() {
    }

    public boolean canBreed() {
        return false;
    }

    @NotNull
    protected Component getTypeName() {
        return Component.translatable((String)this.getType().getDescriptionId());
    }

    public boolean wantsToPickUp(@NotNull ItemStack pStack) {
        return false;
    }

    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pSpawnType, @Nullable SpawnGroupData pSpawnGroupData) {
        this.setVillagerData(this.getVillagerData().setProfession(VillagerProfession.NITWIT));
        return super.finalizeSpawn(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
    }

    public void thunderHit(@NotNull ServerLevel level, @NotNull LightningBolt bolt) {
    }

    public void gossip(@NotNull ServerLevel level, @NotNull Villager villager, long gameTime) {
    }

    public void startSleeping(@NotNull BlockPos blockPos) {
    }

    protected void updateTrades() {
        VillagerTrades.ItemListing[] avillagertrades$itemlisting;
        VillagerData villagerdata = this.getVillagerData();
        Int2ObjectMap<VillagerTrades.ItemListing[]> int2objectmap = DSTrades.LEADER_TRADES;
        if (!int2objectmap.isEmpty() && (avillagertrades$itemlisting = (VillagerTrades.ItemListing[])int2objectmap.get(villagerdata.getLevel())) != null) {
            MerchantOffers merchantoffers = this.getOffers();
            this.addOffersFromItemListings(merchantoffers, avillagertrades$itemlisting, 2);
        }
    }

    protected void customServerAiStep() {
        Player player = this.getTradingPlayer();
        super.customServerAiStep();
        if (player != null && this.getTradingPlayer() == null) {
            this.setTradingPlayer(player);
        }
    }
}

