/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.creatures;

import by.dragonsurvivalteam.dragonsurvival.client.render.util.RandomAnimationPicker;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.Hunter;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.KnightEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.goals.FollowSpecificMobGoal;
import by.dragonsurvivalteam.dragonsurvival.common.entity.goals.WindupMeleeAttackGoal;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.util.AnimationUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class HoundEntity
extends Hunter {
    @ConfigRange(min=1.0)
    @Translation(key="hound_health", type=Translation.Type.CONFIGURATION, comments={"Base value for the max health attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "hound"}, key="hound_health")
    public static double MAX_HEALTH = 10.0;
    @ConfigRange(min=0.0)
    @Translation(key="hound_attack_damage", type=Translation.Type.CONFIGURATION, comments={"Base value for the attack damage attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "hound"}, key="hound_damage")
    public static int ATTACK_DAMAGE = 2;
    @ConfigRange(min=0.0)
    @Translation(key="hound_attack_knockback", type=Translation.Type.CONFIGURATION, comments={"Base value for the attack knockback attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "hound"}, key="hound_attack_knockback")
    public static int ATTACK_KNOCKBACK = 0;
    @ConfigRange(min=0.0)
    @Translation(key="hound_movement_speed", type=Translation.Type.CONFIGURATION, comments={"Base value for the movement speed attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "hound"}, key="hound_movement_speed")
    public static double MOVEMENT_SPEED = 0.45;
    @ConfigRange(min=0.0)
    @Translation(key="hound_armor", type=Translation.Type.CONFIGURATION, comments={"Base value for the armor attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "hound"}, key="hound_armor")
    public static double ARMOR = 0.0;
    @ConfigRange(min=0.0)
    @Translation(key="hound_armor_toughness", type=Translation.Type.CONFIGURATION, comments={"Base value for the armor toughness attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "hound"}, key="hound_armor_toughness")
    public static double ARMOR_TOUGHNESS = 0.0;
    @ConfigRange(min=0.0)
    @Translation(key="hound_knockback_resistance", type=Translation.Type.CONFIGURATION, comments={"Base value for the knockback resistance attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "hound"}, key="hound_knockback_resistance")
    public static double KNOCKBACK_RESISTANCE = 0.0;
    @ConfigRange(min=0.0, max=1.0)
    @Translation(key="hound_slowdown_chance", type=Translation.Type.CONFIGURATION, comments={"Determines the chance (in %) of the knight hound applying the slowness effect when they attack"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "hound"}, key="hound_slowdown_chance")
    public static Double SLOWDOWN_CHANCE = 0.5;
    private static final EntityDataAccessor<Integer> VARIETY = SynchedEntityData.defineId(HoundEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DID_SLOWDOWN_ATTACK = SynchedEntityData.defineId(HoundEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private RawAnimation currentIdleAnim;
    private boolean isIdleAnimSet = false;
    private static final RawAnimation ATTACK = RawAnimation.begin().thenLoop("attack");
    private static final RawAnimation SPECIAL_ATTACK = RawAnimation.begin().thenLoop("special_attack");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("run");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("walk");
    private static final RawAnimation SWIM = RawAnimation.begin().thenLoop("swim");
    private static final RandomAnimationPicker IDLE_ANIMS = new RandomAnimationPicker(new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("idle1"), 97.0f), new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("idle2"), 3.0f));

    @Override
    public double maxHealthConfig() {
        return MAX_HEALTH;
    }

    @Override
    public double attackDamageConfig() {
        return ATTACK_DAMAGE;
    }

    @Override
    public double attackKnockback() {
        return ATTACK_KNOCKBACK;
    }

    @Override
    public double movementSpeedConfig() {
        return MOVEMENT_SPEED;
    }

    @Override
    public double armorConfig() {
        return ARMOR;
    }

    @Override
    public double armorToughnessConfig() {
        return ARMOR_TOUGHNESS;
    }

    @Override
    public double knockbackResistanceConfig() {
        return KNOCKBACK_RESISTANCE;
    }

    public HoundEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new WindupMeleeAttackGoal(this, 1.0, 8));
        this.goalSelector.addGoal(8, (Goal)new FollowSpecificMobGoal((Mob)this, 0.6, 10.0f, 20.0f, target -> target instanceof KnightEntity));
    }

    public int getCurrentSwingDuration() {
        return 8;
    }

    public double getRunThreshold() {
        return 0.15;
    }

    public double getWalkThreshold() {
        return 0.01;
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIETY, (Object)0);
        builder.define(DID_SLOWDOWN_ATTACK, (Object)false);
    }

    public int getVariety() {
        return (Integer)this.entityData.get(VARIETY);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compoundNBT) {
        super.addAdditionalSaveData(compoundNBT);
        compoundNBT.putInt("Variety", ((Integer)this.entityData.get(VARIETY)).intValue());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compoundNBT) {
        super.readAdditionalSaveData(compoundNBT);
        this.entityData.set(VARIETY, (Object)compoundNBT.getInt("Variety"));
    }

    @Override
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pSpawnType, @Nullable SpawnGroupData pSpawnGroupData) {
        this.entityData.set(VARIETY, (Object)this.random.nextInt(8));
        return super.finalizeSpawn(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "everything", 3, this::fullPredicate));
    }

    private boolean isNotIdle() {
        double movement = AnimationUtils.getMovementSpeed((LivingEntity)this);
        return this.swingTime > 0 || movement > this.getWalkThreshold() || this.isInWater();
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        if (SLOWDOWN_CHANCE > 0.0 && entity instanceof LivingEntity) {
            if (this.random.nextDouble() > SLOWDOWN_CHANCE) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200));
                this.entityData.set(DID_SLOWDOWN_ATTACK, (Object)true);
            } else {
                this.entityData.set(DID_SLOWDOWN_ATTACK, (Object)false);
            }
        }
        return super.doHurtTarget(entity);
    }

    public PlayState fullPredicate(AnimationState<HoundEntity> state) {
        double movement = AnimationUtils.getMovementSpeed((LivingEntity)this);
        if (this.isIdleAnimSet) {
            boolean bl = this.isIdleAnimSet = !this.isNotIdle();
        }
        if (this.swingTime > 0) {
            if (((Boolean)this.entityData.get(DID_SLOWDOWN_ATTACK)).booleanValue()) {
                return state.setAndContinue(SPECIAL_ATTACK);
            }
            return state.setAndContinue(ATTACK);
        }
        if (this.isInWater()) {
            return state.setAndContinue(SWIM);
        }
        if (movement > this.getRunThreshold()) {
            return state.setAndContinue(RUN);
        }
        if (movement > this.getWalkThreshold()) {
            return state.setAndContinue(WALK);
        }
        return state.setAndContinue(this.getIdleAnim());
    }

    public RawAnimation getIdleAnim() {
        if (!this.isIdleAnimSet) {
            this.currentIdleAnim = IDLE_ANIMS.pickRandomAnimation();
            this.isIdleAnimSet = true;
        }
        return this.currentIdleAnim;
    }
}

