/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.effects;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.capability.EntityStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.effects.ModifiableMobEffect;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.EffectHandler;
import by.dragonsurvivalteam.dragonsurvival.common.particles.SmallFireParticleOption;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDamageTypes;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.util.AdditionalEffectData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class BurnEffect
extends ModifiableMobEffect {
    public BurnEffect(MobEffectCategory type, int color, boolean incurable) {
        super(type, color, incurable);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        double distance;
        float damage;
        if (entity.fireImmune() || entity.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) || entity.isInWaterRainOrBubble()) {
            return false;
        }
        EntityStateHandler data = (EntityStateHandler)entity.getData(DSDataAttachments.ENTITY_HANDLER);
        if (data.lastPos == null) {
            data.lastPos = entity.position();
        }
        if (!DragonStateProvider.isDragon((Entity)entity)) {
            SmallFireParticleOption particle = new SmallFireParticleOption(37.0f, false);
            for (int i = 0; i < 4; ++i) {
                EffectHandler.renderEffectParticle(entity, particle);
            }
        }
        if (data.lastPos != null && (damage = (float)(amplifier + 1) * Mth.clamp((float)((float)(distance = entity.distanceToSqr(data.lastPos))), (float)0.0f, (float)10.0f)) > 0.0f) {
            if (!entity.isOnFire()) {
                entity.setRemainingFireTicks(1);
            }
            Entity effectApplier = null;
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                effectApplier = ((AdditionalEffectData)entity.getEffect(DSEffects.BURN)).dragonSurvival$getApplier(serverLevel);
            }
            entity.hurt(new DamageSource(DSDamageTypes.get(entity.level(), DSDamageTypes.BURN), effectApplier), damage);
        }
        data.lastPos = entity.position();
        return super.applyEffectTick(entity, amplifier);
    }
}

