/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class SleepOnTreasureTrigger
extends SimpleCriterionTrigger<SleepOnTreasureInstance> {
    public void trigger(ServerPlayer player, int count) {
        this.trigger(player, triggerInstance -> triggerInstance.nearbyTreasureAmount.map(integer -> integer < count).orElse(true));
    }

    @NotNull
    public Codec<SleepOnTreasureInstance> codec() {
        return SleepOnTreasureInstance.CODEC;
    }

    public record SleepOnTreasureInstance(Optional<ContextAwarePredicate> player, Optional<Integer> nearbyTreasureAmount) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<SleepOnTreasureInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(SleepOnTreasureInstance::player), (App)Codec.INT.optionalFieldOf("nearby_treasure_amount").forGetter(SleepOnTreasureInstance::nearbyTreasureAmount)).apply((Applicative)instance, SleepOnTreasureInstance::new));
    }
}

