/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;

public record WeatherPredicate(Optional<Boolean> isRaining, Optional<Boolean> isThundering, Optional<Boolean> isSnowing, Optional<Boolean> isRainingOrSnowing) {
    public static final Codec<WeatherPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("is_raining").forGetter(WeatherPredicate::isRaining), (App)Codec.BOOL.optionalFieldOf("is_thundering").forGetter(WeatherPredicate::isThundering), (App)Codec.BOOL.optionalFieldOf("is_snowing").forGetter(WeatherPredicate::isSnowing), (App)Codec.BOOL.optionalFieldOf("is_raining_or_snowing").forGetter(WeatherPredicate::isRainingOrSnowing)).apply((Applicative)instance, WeatherPredicate::new));

    public boolean matches(ServerLevel level, Vec3 position) {
        if (this.isRainingOrSnowing.isPresent() && this.isRainingOrSnowing.get().booleanValue() != this.isRainingOrSnowing(level, BlockPos.containing((Position)position))) {
            return false;
        }
        if (this.isRaining.isPresent() && this.isRaining.get().booleanValue() != level.isRainingAt(BlockPos.containing((Position)position))) {
            return false;
        }
        if (this.isThundering.isPresent() && this.isThundering.get().booleanValue() != level.isThundering()) {
            return false;
        }
        return !this.isSnowing.isPresent() || this.isSnowing.get().booleanValue() == this.isSnowing(level, BlockPos.containing((Position)position));
    }

    private boolean isSnowing(ServerLevel level, BlockPos position) {
        if (!level.isRaining()) {
            return false;
        }
        if (!level.canSeeSky(position)) {
            return false;
        }
        Biome biome = (Biome)level.getBiome(position).value();
        return biome.getPrecipitationAt(position) == Biome.Precipitation.SNOW;
    }

    private boolean isRainingOrSnowing(ServerLevel level, BlockPos position) {
        if (!level.isRaining()) {
            return false;
        }
        if (!level.canSeeSky(position)) {
            return false;
        }
        Biome biome = (Biome)level.getBiome(position).value();
        Biome.Precipitation precipitation = biome.getPrecipitationAt(position);
        return precipitation == Biome.Precipitation.RAIN || precipitation == Biome.Precipitation.SNOW;
    }
}

