/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record NearbyEntityPredicate(HolderSet<EntityType<?>> entityTypes, int radius) {
    public static final Codec<NearbyEntityPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENTITY_TYPE).fieldOf("entity_types").forGetter(NearbyEntityPredicate::entityTypes), (App)Codec.INT.fieldOf("radius").forGetter(NearbyEntityPredicate::radius)).apply((Applicative)instance, NearbyEntityPredicate::new));

    public static NearbyEntityPredicate of(int radius, EntityType<?> ... types) {
        ArrayList holders = new ArrayList();
        for (EntityType<?> type : types) {
            BuiltInRegistries.ENTITY_TYPE.getResourceKey(type).ifPresent(key -> holders.add(BuiltInRegistries.ENTITY_TYPE.getHolderOrThrow(key)));
        }
        return new NearbyEntityPredicate((HolderSet<EntityType<?>>)HolderSet.direct(holders), radius);
    }

    public boolean matches(ServerLevel level, Vec3 position) {
        for (Entity entity : level.getEntities(null, AABB.ofSize((Vec3)position, (double)(this.radius * 2), (double)(this.radius * 2), (double)(this.radius * 2)))) {
            if (!entity.getType().is(this.entityTypes)) continue;
            return true;
        }
        return false;
    }
}

