/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.Storage;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.attachment.AttachmentType;

public class DurationInstanceBase<B extends Storage<I>, I extends DurationInstance<?>> {
    public static final Codec<DurationInstanceBase<?, ?>> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(DurationInstanceBase::id), (App)LevelBasedValue.CODEC.optionalFieldOf("duration", (Object)DragonAbilities.INFINITE_DURATION).forGetter(DurationInstanceBase::duration), (App)Codec.BOOL.optionalFieldOf("should_remove_automatically", (Object)false).forGetter(DurationInstanceBase::shouldRemoveAutomatically), (App)LootItemCondition.DIRECT_CODEC.optionalFieldOf("early_removal_condition").forGetter(DurationInstanceBase::earlyRemovalCondition), (App)ResourceLocation.CODEC.optionalFieldOf("custom_icon").forGetter(DurationInstanceBase::customIcon), (App)Codec.BOOL.optionalFieldOf("is_hidden", (Object)false).forGetter(DurationInstanceBase::isHidden)).apply((Applicative)instance, DurationInstanceBase::new));
    private final ResourceLocation id;
    private final LevelBasedValue duration;
    private final boolean shouldRemoveAutomatically;
    private final Optional<LootItemCondition> earlyRemovalCondition;
    private final Optional<ResourceLocation> customIcon;
    private final boolean isHidden;

    public DurationInstanceBase(DurationInstanceBase<?, ?> base) {
        this(base.id(), base.duration(), base.shouldRemoveAutomatically(), base.earlyRemovalCondition(), base.customIcon(), base.isHidden());
    }

    public DurationInstanceBase(ResourceLocation id, LevelBasedValue duration, boolean shouldRemoveAutomatically, Optional<LootItemCondition> earlyRemovalCondition, Optional<ResourceLocation> customIcon, boolean isHidden) {
        this.id = id;
        this.duration = duration;
        this.shouldRemoveAutomatically = shouldRemoveAutomatically;
        this.earlyRemovalCondition = earlyRemovalCondition;
        this.customIcon = customIcon;
        this.isHidden = isHidden;
    }

    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        int newDuration = (int)this.duration.calculate(ability.level());
        Storage data = (Storage)target.getData(this.type());
        DurationInstance instance = (DurationInstance)data.get(this.id);
        if (instance != null && instance.appliedAbilityLevel() == ability.level() && instance.currentDuration() == newDuration) {
            return;
        }
        data.remove(target, instance);
        data.add(target, this.createInstance(dragon, ability, newDuration));
    }

    public void remove(Entity target) {
        Storage data = (Storage)target.getData(this.type());
        data.remove(target, (DurationInstance)data.get(this.id));
    }

    public static Builder create(ResourceLocation id) {
        return new Builder(id);
    }

    public ResourceLocation id() {
        return this.id;
    }

    public LevelBasedValue duration() {
        return this.duration;
    }

    public boolean shouldRemoveAutomatically() {
        return this.shouldRemoveAutomatically;
    }

    public Optional<LootItemCondition> earlyRemovalCondition() {
        return this.earlyRemovalCondition;
    }

    public Optional<ResourceLocation> customIcon() {
        return this.customIcon;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public I createInstance(ServerPlayer dragon, DragonAbilityInstance ability, int currentDuration) {
        throw new AssertionError((Object)"This methods requires an override");
    }

    public AttachmentType<B> type() {
        throw new AssertionError((Object)"This methods requires an override");
    }

    public static class Builder {
        private final ResourceLocation id;
        private LevelBasedValue duration;
        private boolean shouldRemoveAutomatically = false;
        private Optional<LootItemCondition> earlyRemovalCondition = Optional.empty();
        private Optional<ResourceLocation> customIcon = Optional.empty();
        private boolean isHidden = false;

        public Builder(ResourceLocation id) {
            this.id = id;
        }

        public Builder infinite() {
            this.duration = DragonAbilities.INFINITE_DURATION;
            return this;
        }

        public Builder duration(LevelBasedValue duration) {
            this.duration = duration;
            return this;
        }

        public Builder removeAutomatically() {
            this.shouldRemoveAutomatically = true;
            return this;
        }

        public Builder earlyRemoval(LootItemCondition condition) {
            this.earlyRemovalCondition = Optional.ofNullable(condition);
            return this;
        }

        public Builder customIcon(ResourceLocation icon) {
            this.customIcon = Optional.ofNullable(icon);
            return this;
        }

        public Builder hidden() {
            this.isHidden = true;
            return this;
        }

        public DurationInstanceBase<?, ?> build() {
            return new DurationInstanceBase(this.id, this.duration, this.shouldRemoveAutomatically, this.earlyRemovalCondition, this.customIcon, this.isHidden);
        }
    }
}

