/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.CommonData;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstance;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstanceBase;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncOxygenBonus;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.OxygenBonuses;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OxygenBonus
extends DurationInstanceBase<OxygenBonuses, Instance> {
    @Translation(comments={"Can breathe in %s for %s additional seconds"})
    private static final String BONUS = Translation.Type.GUI.wrap("oxygen_bonus.bonus");
    @Translation(comments={"Can breathe in %s indefinitely"})
    private static final String UNLIMITED = Translation.Type.GUI.wrap("oxygen_bonus.unlimited");
    @Translation(comments={"all fluids"})
    private static final String ALL_FLUIDS = Translation.Type.GUI.wrap("oxygen_bonus.all_fluids");
    public static float NONE;
    public static final Codec<OxygenBonus> CODEC;
    private final Optional<HolderSet<FluidType>> fluids;
    private final LevelBasedValue oxygenBonus;

    public OxygenBonus(DurationInstanceBase<?, ?> base, Optional<HolderSet<FluidType>> fluids, LevelBasedValue oxygenBonus) {
        super(base);
        this.fluids = fluids;
        this.oxygenBonus = oxygenBonus;
    }

    public MutableComponent getDescription(int abilityLevel) {
        MutableComponent fluids = this.fluids.isEmpty() ? DSColors.dynamicValue(Component.translatable((String)ALL_FLUIDS)) : Functions.translateHolderSet(this.fluids.get(), fluid -> ((FluidType)fluid.value()).getDescriptionId());
        float bonus = this.oxygenBonus.calculate(abilityLevel);
        MutableComponent description = bonus == -1.0f ? Component.translatable((String)UNLIMITED, (Object[])new Object[]{fluids}) : Component.translatable((String)BONUS, (Object[])new Object[]{fluids, (int)bonus});
        if (this.duration().calculate(abilityLevel) != -1.0f) {
            description.append((Component)Component.translatable((String)LangKey.ABILITY_EFFECT_DURATION, (Object[])new Object[]{(int)this.duration().calculate(abilityLevel)}));
        }
        return description;
    }

    @Override
    public Instance createInstance(ServerPlayer dragon, DragonAbilityInstance ability, int currentDuration) {
        return new Instance(this, CommonData.from(this.id(), dragon, ability, this.customIcon(), this.shouldRemoveAutomatically()), currentDuration);
    }

    @Override
    public AttachmentType<OxygenBonuses> type() {
        return (AttachmentType)DSDataAttachments.OXYGEN_BONUSES.value();
    }

    public Optional<HolderSet<FluidType>> fluidTypes() {
        return this.fluids;
    }

    public LevelBasedValue oxygenBonus() {
        return this.oxygenBonus;
    }

    static {
        CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)DurationInstanceBase.CODEC.fieldOf("base").forGetter(identity -> identity), (App)RegistryCodecs.homogeneousList((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES).optionalFieldOf("fluid_types").forGetter(OxygenBonus::fluidTypes), (App)LevelBasedValue.CODEC.fieldOf("oxygen_bonus").forGetter(OxygenBonus::oxygenBonus)).apply((Applicative)instance, OxygenBonus::new));
    }

    public static class Instance
    extends DurationInstance<OxygenBonus> {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> DurationInstance.codecStart(instance, () -> CODEC).apply((Applicative)instance, Instance::new));

        public Instance(OxygenBonus baseData, CommonData commonData, int currentDuration) {
            super(baseData, commonData, currentDuration);
        }

        public float getOxygenBonus(Holder<FluidType> fluid) {
            if (!((OxygenBonus)this.baseData()).fluidTypes().map(set -> set.contains(fluid)).orElse(true).booleanValue()) {
                return NONE;
            }
            return ((OxygenBonus)this.baseData()).oxygenBonus().calculate(this.appliedAbilityLevel());
        }

        @Override
        public Component getDescription() {
            return ((OxygenBonus)this.baseData()).getDescription(this.appliedAbilityLevel());
        }

        @Override
        public void onAddedToStorage(Entity storageHolder) {
            if (storageHolder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)storageHolder;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncOxygenBonus(player.getId(), this, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @Override
        public void onRemovalFromStorage(Entity storageHolder) {
            if (storageHolder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)storageHolder;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncOxygenBonus(player.getId(), this, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public Tag save(@NotNull HolderLookup.Provider provider) {
            return (Tag)CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
        }

        @Nullable
        public static Instance load(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            return CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).orElse(null);
        }
    }
}

