/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Modifier;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ModifierType;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.CommonData;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstance;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstanceBase;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncModifierWithDuration;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ModifiersWithDuration;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.AttributeModifierSupplier;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.ModifierEffect;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModifierWithDuration
extends DurationInstanceBase<ModifiersWithDuration, Instance> {
    public static final Codec<ModifierWithDuration> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)DurationInstanceBase.CODEC.fieldOf("base").forGetter(identity -> identity), (App)Modifier.CODEC.listOf().fieldOf("modifiers").forGetter(ModifierWithDuration::modifiers)).apply((Applicative)instance, ModifierWithDuration::new));
    private final List<Modifier> modifiers;

    public ModifierWithDuration(DurationInstanceBase<?, ?> base, List<Modifier> modifiers) {
        super(base);
        this.modifiers = modifiers;
    }

    public MutableComponent getDescription(int abilityLevel) {
        double duration = Functions.ticksToSeconds((int)this.duration().calculate(abilityLevel));
        MutableComponent description = null;
        for (Modifier modifier : this.modifiers) {
            MutableComponent name = modifier.getFormattedDescription(abilityLevel, false);
            if (duration > 0.0) {
                name.append((Component)Component.translatable((String)LangKey.ABILITY_EFFECT_DURATION, (Object[])new Object[]{DSColors.dynamicValue(duration)}));
            }
            if (description == null) {
                description = Component.literal((String)"\n").append((Component)name);
                continue;
            }
            description.append((Component)Component.literal((String)"\n")).append((Component)name);
        }
        return Objects.requireNonNullElse(description, Component.empty());
    }

    @Override
    public Instance createInstance(ServerPlayer dragon, DragonAbilityInstance ability, int currentDuration) {
        return new Instance(this, CommonData.from(this.id(), dragon, ability, this.customIcon(), this.shouldRemoveAutomatically()), currentDuration);
    }

    @Override
    public AttachmentType<ModifiersWithDuration> type() {
        return (AttachmentType)DSDataAttachments.MODIFIERS_WITH_DURATION.value();
    }

    public List<Modifier> modifiers() {
        return this.modifiers;
    }

    public static class Instance
    extends DurationInstance<ModifierWithDuration>
    implements AttributeModifierSupplier {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> DurationInstance.codecStart(instance, () -> CODEC).and((App)Codec.compoundList((Codec)BuiltInRegistries.ATTRIBUTE.holderByNameCodec(), (Codec)ResourceLocation.CODEC.listOf()).xmap(pairs -> {
            HashMap ids = new HashMap();
            pairs.forEach(pair -> ((List)pair.getSecond()).forEach(id -> ids.computeIfAbsent((Holder)pair.getFirst(), key -> new ArrayList()).add(id)));
            return ids;
        }, ids -> {
            ArrayList pairs = new ArrayList();
            ids.forEach((attribute, value) -> pairs.add(new Pair(attribute, value)));
            return pairs;
        }).fieldOf("ids").forGetter(Instance::getStoredIds)).apply((Applicative)instance, Instance::new));
        private final Map<Holder<Attribute>, List<ResourceLocation>> ids;

        public Instance(ModifierWithDuration baseData, CommonData commonData, int currentDuration) {
            this(baseData, commonData, currentDuration, new HashMap<Holder<Attribute>, List<ResourceLocation>>());
        }

        public Instance(ModifierWithDuration baseData, CommonData commonData, int currentDuration, Map<Holder<Attribute>, List<ResourceLocation>> ids) {
            super(baseData, commonData, currentDuration);
            this.ids = ids;
        }

        @Override
        public Component getDescription() {
            MutableComponent description = ((ModifierWithDuration)this.baseData()).getDescription(this.appliedAbilityLevel());
            return Component.translatable((String)ModifierEffect.ATTRIBUTE_MODIFIERS).append((Component)description);
        }

        @Override
        public void onAddedToStorage(Entity storageHolder) {
            if (!(storageHolder instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)storageHolder;
            this.applyModifiers(livingEntity, this.appliedAbilityLevel());
            if (storageHolder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)storageHolder;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncModifierWithDuration(player.getId(), this, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @Override
        public void onRemovalFromStorage(Entity storageHolder) {
            if (!(storageHolder instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)storageHolder;
            this.removeModifiers(livingEntity);
            if (storageHolder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)storageHolder;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncModifierWithDuration(player.getId(), this, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public Tag save(@NotNull HolderLookup.Provider provider) {
            return (Tag)CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
        }

        @Nullable
        public static Instance load(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            return CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).orElse(null);
        }

        @Override
        public List<Modifier> modifiers() {
            return ((ModifierWithDuration)this.baseData()).modifiers();
        }

        @Override
        public void storeId(Holder<Attribute> attribute, ResourceLocation id) {
            this.ids.computeIfAbsent(attribute, key -> new ArrayList()).add(id);
        }

        @Override
        public Map<Holder<Attribute>, List<ResourceLocation>> getStoredIds() {
            return this.ids;
        }

        @Override
        public ModifierType getModifierType() {
            return ModifierType.CUSTOM;
        }
    }
}

