/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import com.mojang.serialization.Codec;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.NotNull;

public enum ModifierType implements StringRepresentable
{
    DRAGON_TYPE("type"),
    DRAGON_BODY("body"),
    DRAGON_STAGE("stage"),
    CUSTOM("custom");

    public static final Codec<ModifierType> CODEC;
    private final String path;

    private ModifierType(String path) {
        this.path = "dragonsurvival/" + path + "/";
    }

    public String path() {
        return this.path;
    }

    public ResourceLocation randomId(Holder<Attribute> attribute, AttributeModifier.Operation operation, RandomSource random) {
        String attributeId = attribute.getRegisteredName().replace(":", ".");
        int hash = Objects.hash(String.valueOf(random.nextInt(100000)), operation.getSerializedName());
        return DragonSurvival.res(this.path() + hash + "/" + attributeId);
    }

    @NotNull
    public String getSerializedName() {
        return this.path();
    }

    static {
        CODEC = StringRepresentable.fromEnum(ModifierType::values);
    }
}

