/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MiscCodecs {
    public static final StreamCodec<ByteBuf, Vec3> VEC3_STREAM_CODEC = new StreamCodec<ByteBuf, Vec3>(){

        @NotNull
        public Vec3 decode(@NotNull ByteBuf buffer) {
            return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }

        public void encode(@NotNull ByteBuf buffer, @NotNull Vec3 input) {
            buffer.writeDouble(input.x());
            buffer.writeDouble(input.y());
            buffer.writeDouble(input.z());
        }
    };
    public static final StreamCodec<ByteBuf, Vec2> VEC2_STREAM_CODEC = new StreamCodec<ByteBuf, Vec2>(){

        @NotNull
        public Vec2 decode(@NotNull ByteBuf buffer) {
            return new Vec2(buffer.readFloat(), buffer.readFloat());
        }

        public void encode(@NotNull ByteBuf buffer, @NotNull Vec2 input) {
            buffer.writeFloat(input.x);
            buffer.writeFloat(input.y);
        }
    };

    public static <E extends Enum<E>> Codec<E> enumCodec(Class<E> enumType) {
        return Codec.STRING.validate(string -> {
            try {
                Enum.valueOf(enumType, string);
                return DataResult.success((Object)string);
            }
            catch (IllegalArgumentException | NullPointerException ignored) {
                return DataResult.error(() -> String.format("[%s] is not a valid entry of [%s]", string, Arrays.toString(enumType.getEnumConstants())));
            }
        }).xmap(string -> Enum.valueOf(enumType, string), Enum::name);
    }

    public static Codec<MinMaxBounds.Doubles> percentageBounds() {
        return MinMaxBounds.Doubles.CODEC.validate(value -> {
            double max;
            double min;
            boolean isValid = true;
            if (value.min().isPresent() && ((min = ((Double)value.min().get()).doubleValue()) < 0.0 || min > 1.0)) {
                isValid = false;
            }
            if (value.max().isPresent() && ((max = ((Double)value.max().get()).doubleValue()) < 0.0 || max > 1.0)) {
                isValid = false;
            }
            return isValid ? DataResult.success((Object)value) : DataResult.error(() -> "Percentage check must be between 0 and 1: [" + String.valueOf(value) + "]");
        });
    }

    public static Codec<Double> doubleRange(double min, double max) {
        return Codec.DOUBLE.validate(value -> value >= min && value <= max ? DataResult.success((Object)value) : DataResult.error(() -> "Value must be within range [" + min + ";" + max + "]: " + value));
    }

    public static Codec<Bounds> bounds() {
        return Bounds.CODEC.validate(value -> {
            if (value.min() >= 1.0 && value.max() > value.min()) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> "Min must be at least 1 and max must be larger than min " + String.valueOf(value));
        });
    }

    public record Bounds(double min, double max) {
        public static final Codec<Bounds> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("min").forGetter(Bounds::min), (App)Codec.DOUBLE.fieldOf("max").forGetter(Bounds::max)).apply((Applicative)instance, instance.stable(Bounds::new)));

        public boolean matches(double value) {
            return this.min <= value && value <= this.max;
        }
    }

    public record DestructionData(EntityPredicate entityPredicate, BlockPredicate blockPredicate, double crushingGrowth, double blockDestructionGrowth, double crushingDamageScalar) {
        public static final Codec<DestructionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.CODEC.fieldOf("entity_predicate").forGetter(DestructionData::entityPredicate), (App)BlockPredicate.CODEC.fieldOf("block_predicate").forGetter(DestructionData::blockPredicate), (App)Codec.DOUBLE.fieldOf("crushing_growth").forGetter(DestructionData::crushingGrowth), (App)Codec.DOUBLE.fieldOf("block_destruction_growth").forGetter(DestructionData::blockDestructionGrowth), (App)Codec.DOUBLE.fieldOf("crushing_damage_scalar").forGetter(DestructionData::crushingDamageScalar)).apply((Applicative)instance, instance.stable(DestructionData::new)));

        public boolean isCrushingAllowed(double growth) {
            return growth >= this.crushingGrowth;
        }

        public boolean isBlockDestructionAllowed(double growth) {
            return growth >= this.blockDestructionGrowth;
        }

        public boolean isDestructionAllowed(double growth) {
            return this.isCrushingAllowed(growth) || this.isBlockDestructionAllowed(growth);
        }
    }
}

