/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;

public record LevelBasedResource(List<Entry> entries) {
    public static final Codec<LevelBasedResource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().xmap(list -> {
        ArrayList sorted = new ArrayList(list);
        Collections.sort(sorted);
        return sorted.reversed();
    }, Function.identity()).fieldOf("texture_entries").forGetter(LevelBasedResource::entries)).apply((Applicative)instance, LevelBasedResource::new));

    public ResourceLocation get(int level) {
        for (Entry entry : this.entries) {
            if (level < entry.fromLevel()) continue;
            return entry.location();
        }
        return this.entries().getFirst().location();
    }

    public record Entry(ResourceLocation location, int fromLevel) implements Comparable<Entry>
    {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture_resource").forGetter(Entry::location), (App)ExtraCodecs.intRange((int)0, (int)255).fieldOf("from_level").forGetter(Entry::fromLevel)).apply((Applicative)instance, Entry::new));

        @Override
        public int compareTo(@NotNull Entry other) {
            if (this.fromLevel < other.fromLevel()) {
                return -1;
            }
            if (this.fromLevel > other.fromLevel()) {
                return 1;
            }
            return 0;
        }
    }
}

