/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;

public record GrowthItem(HolderSet<Item> items, int growthInTicks, int maximumUsages) {
    public static final int INFINITE_USAGES = -1;
    public static final Codec<GrowthItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM).fieldOf("items").forGetter(GrowthItem::items), (App)Codec.INT.fieldOf("growth_in_ticks").forGetter(GrowthItem::growthInTicks), (App)ExtraCodecs.intRange((int)-1, (int)Integer.MAX_VALUE).optionalFieldOf("maximum_usages", (Object)-1).forGetter(GrowthItem::maximumUsages)).apply((Applicative)instance, instance.stable(GrowthItem::new)));

    public boolean canBeUsed(DragonStateHandler handler, Item item) {
        if (this.items.contains((Holder)item.builtInRegistryHolder())) {
            if (this.maximumUsages == -1) {
                return true;
            }
            return handler.getGrowthUses(item) < this.maximumUsages;
        }
        return false;
    }

    public static GrowthItem create(int growthInTicks, TagKey<Item> tag) {
        return GrowthItem.create(growthInTicks, -1, tag);
    }

    public static GrowthItem create(int growthInTicks, int maximumUsages, TagKey<Item> tag) {
        return new GrowthItem((HolderSet<Item>)BuiltInRegistries.ITEM.getOrCreateTag(tag), growthInTicks, maximumUsages);
    }

    public static GrowthItem create(int growthInTicks, Item ... items) {
        return GrowthItem.create(growthInTicks, -1, items);
    }

    public static GrowthItem create(int growthInTicks, int maximumUsages, Item ... items) {
        return new GrowthItem((HolderSet<Item>)HolderSet.direct(Arrays.stream(items).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).wrapAsHolder(arg_0)).toList()), growthInTicks, maximumUsages);
    }
}

