/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record DragonAbilityHolder(HolderSet<DragonAbility> abilities, Optional<HolderSet<DragonSpecies>> applicableSpecies, boolean isRemoval) {
    public static final Codec<DragonAbilityHolder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList(DragonAbility.REGISTRY).fieldOf("abilities").forGetter(DragonAbilityHolder::abilities), (App)RegistryCodecs.homogeneousList(DragonSpecies.REGISTRY).optionalFieldOf("applicable_species").forGetter(DragonAbilityHolder::applicableSpecies), (App)Codec.BOOL.optionalFieldOf("is_removal", (Object)false).forGetter(DragonAbilityHolder::isRemoval)).apply((Applicative)instance, DragonAbilityHolder::new));

    public boolean use(ServerPlayer player, DragonStateHandler handler, MagicData magic) {
        if (this.applicableSpecies.map(set -> !set.contains(handler.species())).orElse(false).booleanValue()) {
            return false;
        }
        boolean wasUsed = false;
        for (Holder ability : this.abilities) {
            DragonAbilityInstance current = magic.getAbility((ResourceKey<DragonAbility>)ability.getKey());
            if (this.isRemoval && current == null || !this.isRemoval && current != null) continue;
            if (this.isRemoval) {
                magic.removeAbility((Player)player, (ResourceKey<DragonAbility>)ability.getKey());
            } else {
                magic.addAbility(player, (Holder<DragonAbility>)ability);
            }
            wasUsed = true;
        }
        return wasUsed;
    }
}

