/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.capability;

import by.dragonsurvivalteam.dragonsurvival.client.util.FakeClientPlayer;
import by.dragonsurvivalteam.dragonsurvival.common.capability.Capabilities;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonStateProvider
implements ICapabilityProvider<Player, Void, DragonStateHandler> {
    @Nullable
    public DragonStateHandler getCapability(@NotNull Player player, @Nullable Void context) {
        return DragonStateProvider.getData(player);
    }

    @NotNull
    public static DragonStateHandler getData(@NotNull Player player) {
        DragonStateHandler fakeData = DragonStateProvider.getFakePlayerHandler((Entity)player);
        if (fakeData != null) {
            return fakeData;
        }
        return (DragonStateHandler)player.getData(DSDataAttachments.DRAGON_HANDLER);
    }

    public static Optional<DragonStateHandler> getOptional(@Nullable Entity entity) {
        if (entity == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((DragonStateHandler)entity.getCapability(Capabilities.DRAGON_CAPABILITY));
    }

    public static boolean isDragon(@Nullable Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        return DragonStateProvider.getData(player).isDragon();
    }

    private static DragonStateHandler getFakePlayerHandler(@NotNull Entity entity) {
        if (!entity.level().isClientSide()) {
            return null;
        }
        if (entity instanceof FakeClientPlayer) {
            FakeClientPlayer fakeClientPlayer = (FakeClientPlayer)entity;
            if (fakeClientPlayer.handler != null) {
                return fakeClientPlayer.handler;
            }
        }
        return null;
    }
}

