/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.blocks;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonPressurePlates
extends PressurePlateBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final TagKey<DragonSpecies> types;
    private final boolean allowHumans;

    public DragonPressurePlates(BlockBehaviour.Properties properties, TagKey<DragonSpecies> types, boolean allowHumans) {
        super(BlockSetType.WARPED, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.types = types;
        this.allowHumans = allowHumans;
    }

    @Nullable
    public TagKey<DragonSpecies> getTypes() {
        return this.types;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos position, @NotNull CollisionContext context) {
        return PRESSED_AABB;
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos position, @NotNull BlockPos facingPosition) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(position, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, position, facingPosition);
    }

    protected int getSignalStrength(Level level, @NotNull BlockPos position) {
        List entities = level.getEntities(null, TOUCH_AABB.move(position));
        if (entities.isEmpty()) {
            return 0;
        }
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (entity.isIgnoringBlockTriggers()) continue;
            DragonStateHandler data = DragonStateProvider.getData(player);
            if (!data.isDragon()) {
                return this.allowHumans ? 15 : 0;
            }
            return this.types != null && data.species().is(this.types) ? 15 : 0;
        }
        return 0;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        if (state.hasProperty((Property)FACING)) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
        }
        return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState rotate(BlockState state, @NotNull Rotation rotation) {
        if (state.hasProperty((Property)FACING)) {
            return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
        }
        return state;
    }

    @NotNull
    public BlockState mirror(BlockState state, @NotNull Mirror mirror) {
        if (state.hasProperty((Property)FACING)) {
            return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
        }
        return state;
    }
}

