/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.blocks;

import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonPressurePlates;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSBlockTags;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonDoor
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    @Nullable
    private final TagKey<DragonSpecies> types;
    private final boolean allowHumans;
    private final boolean requiresPower;

    public DragonDoor(BlockBehaviour.Properties properties) {
        this(properties, null, true, false);
    }

    public DragonDoor(BlockBehaviour.Properties properties, TagKey<DragonSpecies> types) {
        this(properties, types, false, false);
    }

    public DragonDoor(BlockBehaviour.Properties properties, boolean requiresPower) {
        this(properties, null, true, requiresPower);
    }

    public DragonDoor(BlockBehaviour.Properties properties, @Nullable TagKey<DragonSpecies> types, boolean allowHumans, boolean requiresPower) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(PART, (Comparable)((Object)Part.BOTTOM))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.types = types;
        this.allowHumans = allowHumans;
        this.requiresPower = requiresPower;
    }

    public boolean isPathfindable(@NotNull BlockState state, PathComputationType type) {
        return switch (type) {
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.getValue((Property)OPEN);
            default -> false;
        };
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos position, @NotNull BlockPos facingPosition) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(position, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (facing.getAxis() == Direction.Axis.Y && state.is(facingState.getBlock())) {
            return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)facingState.getValue((Property)FACING)))).setValue((Property)OPEN, (Comparable)((Boolean)facingState.getValue((Property)OPEN)))).setValue(HINGE, (Comparable)((DoorHingeSide)facingState.getValue(HINGE)))).setValue((Property)POWERED, (Comparable)((Boolean)facingState.getValue((Property)POWERED)));
        }
        boolean isBottomWithoutTopBlocks = state.getValue(PART) == Part.BOTTOM && level.getBlockState(position.above()).getBlock() != this;
        return this.canSurvive(state, (LevelReader)level, position) && !isBottomWithoutTopBlocks ? super.updateShape(state, facing, facingState, level, position, facingPosition) : Blocks.AIR.defaultBlockState();
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos position, @NotNull Block neighborBlock, @NotNull BlockPos neighborPosition, boolean isMoving) {
        boolean hasPower;
        boolean isValidType;
        if (neighborBlock == this) {
            return;
        }
        boolean bl = isValidType = this.types == null;
        if (!isValidType && neighborBlock instanceof DragonPressurePlates) {
            DragonPressurePlates plate = (DragonPressurePlates)neighborBlock;
            boolean bl2 = isValidType = this.types == plate.getTypes();
        }
        if (!isValidType) {
            return;
        }
        boolean bl3 = level.hasNeighborSignal(position) || level.hasNeighborSignal(position.relative(state.getValue(PART) == Part.BOTTOM ? Direction.UP : Direction.DOWN)) ? true : (hasPower = false);
        if (hasPower != (Boolean)state.getValue((Property)POWERED)) {
            if (hasPower != (Boolean)state.getValue((Property)OPEN)) {
                this.playSound(null, level, position, state, hasPower);
            }
            level.setBlock(position, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasPower))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(hasPower)), 2);
        }
    }

    private void playSound(@Nullable Entity entity, Level level, BlockPos blockPosition, BlockState blockState, boolean isOpening) {
        level.playSound(entity, blockPosition, this.getSound(blockState, isOpening), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    private SoundEvent getSound(BlockState blockState, boolean isOpening) {
        if (blockState.is(DSBlockTags.WOODEN_DRAGON_DOORS)) {
            return isOpening ? SoundEvents.WOODEN_DOOR_OPEN : SoundEvents.WOODEN_DOOR_CLOSE;
        }
        return isOpening ? SoundEvents.IRON_DOOR_OPEN : SoundEvents.IRON_DOOR_CLOSE;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos position, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        boolean canOpen;
        DragonStateHandler data = DragonStateProvider.getData(player);
        if (!data.isDragon()) {
            canOpen = this.allowHumans;
        } else {
            boolean bl = canOpen = this.types == null || data.species().is(this.types);
        }
        if (!this.requiresPower && canOpen) {
            BlockState newState = (BlockState)((BlockState)state.cycle((Property)OPEN)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(position).getType() == Fluids.WATER));
            level.setBlock(position, newState, 10);
            this.playSound((Entity)player, level, position, newState, (Boolean)newState.getValue((Property)OPEN));
            if (newState.getValue(PART) == Part.TOP) {
                level.setBlock(position.below(2), (BlockState)((BlockState)newState.setValue(PART, (Comparable)((Object)Part.BOTTOM))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(position.below(2)).getType() == Fluids.WATER)), 10);
                level.setBlock(position.below(), (BlockState)((BlockState)newState.setValue(PART, (Comparable)((Object)Part.MIDDLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(position.below()).getType() == Fluids.WATER)), 10);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        return mirror == Mirror.NONE ? state : (BlockState)state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING))).cycle(HINGE);
    }

    public long getSeed(BlockState state, BlockPos position) {
        return Mth.getSeed((int)position.getX(), (int)position.below(state.getValue(PART) == Part.BOTTOM ? 0 : 1).getY(), (int)position.getZ());
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos position) {
        BlockPos below = position.below();
        BlockState stateBelow = level.getBlockState(below);
        return switch (((Part)((Object)state.getValue(PART))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> stateBelow.isFaceSturdy((BlockGetter)level, below, Direction.UP);
            case 1 -> {
                if (stateBelow.getBlock() == this && level.getBlockState(position.above()).getBlock() == this) {
                    yield true;
                }
                yield false;
            }
            case 2 -> stateBelow.getBlock() == this;
        };
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos position, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean isClosed = (Boolean)state.getValue((Property)OPEN) == false;
        boolean isRightHinge = state.getValue(HINGE) == DoorHingeSide.RIGHT;
        return switch (facing) {
            case Direction.SOUTH -> {
                if (isClosed) {
                    yield SOUTH_AABB;
                }
                if (isRightHinge) {
                    yield EAST_AABB;
                }
                yield WEST_AABB;
            }
            case Direction.WEST -> {
                if (isClosed) {
                    yield WEST_AABB;
                }
                if (isRightHinge) {
                    yield SOUTH_AABB;
                }
                yield NORTH_AABB;
            }
            case Direction.NORTH -> {
                if (isClosed) {
                    yield NORTH_AABB;
                }
                if (isRightHinge) {
                    yield WEST_AABB;
                }
                yield EAST_AABB;
            }
            default -> isClosed ? EAST_AABB : (isRightHinge ? NORTH_AABB : SOUTH_AABB);
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos clickedPosition = context.getClickedPos();
        if (clickedPosition.getY() < context.getLevel().getMaxBuildHeight() && context.getLevel().getBlockState(clickedPosition.above()).canBeReplaced(context) && context.getLevel().getBlockState(clickedPosition.above(2)).canBeReplaced(context)) {
            Level level = context.getLevel();
            boolean hasPower = level.hasNeighborSignal(clickedPosition) || level.hasNeighborSignal(clickedPosition.above());
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(HINGE, (Comparable)this.getHinge(context))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasPower))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(hasPower))).setValue(PART, (Comparable)((Object)Part.BOTTOM))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER && context.getLevel().getBlockState(clickedPosition).getBlock() == DSBlocks.SEA_DRAGON_DOOR.get()));
        }
        return null;
    }

    private DoorHingeSide getHinge(BlockPlaceContext context) {
        boolean flag1;
        Level iblockreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getHorizontalDirection();
        BlockPos blockpos1 = blockpos.above();
        Direction direction1 = direction.getCounterClockWise();
        BlockPos blockpos2 = blockpos.relative(direction1);
        BlockState blockstate = iblockreader.getBlockState(blockpos2);
        BlockPos blockpos3 = blockpos1.relative(direction1);
        BlockState blockstate1 = iblockreader.getBlockState(blockpos3);
        Direction direction2 = direction.getClockWise();
        BlockPos blockpos4 = blockpos.relative(direction2);
        BlockState blockstate2 = iblockreader.getBlockState(blockpos4);
        BlockPos blockpos5 = blockpos1.relative(direction2);
        BlockState blockstate3 = iblockreader.getBlockState(blockpos5);
        int i = (blockstate.isCollisionShapeFullBlock((BlockGetter)iblockreader, blockpos2) ? -1 : 0) + (blockstate1.isCollisionShapeFullBlock((BlockGetter)iblockreader, blockpos3) ? -1 : 0) + (blockstate2.isCollisionShapeFullBlock((BlockGetter)iblockreader, blockpos4) ? 1 : 0) + (blockstate3.isCollisionShapeFullBlock((BlockGetter)iblockreader, blockpos5) ? 1 : 0);
        boolean flag = blockstate.is((Block)this) && blockstate.getValue(PART) == Part.BOTTOM;
        boolean bl = flag1 = blockstate2.is((Block)this) && blockstate2.getValue(PART) == Part.BOTTOM;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.getStepX();
                int k = direction.getStepZ();
                Vec3 vec3d = context.getClickLocation();
                double d0 = vec3d.x - (double)blockpos.getX();
                double d1 = vec3d.z - (double)blockpos.getZ();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public void setPlacedBy(Level level, BlockPos position, BlockState state, LivingEntity placer, @NotNull ItemStack stack) {
        level.setBlock(position.above(), (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)Part.MIDDLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(position.above()).getType() == Fluids.WATER)), 3);
        level.setBlock(position.above(2), (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)Part.TOP))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(position.above(2)).getType() == Fluids.WATER)), 3);
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, @NotNull BlockPos position, @NotNull BlockState state, @NotNull Player player) {
        if (!level.isClientSide()) {
            BlockPos bottomPos;
            BlockState bottomState;
            Part part = (Part)((Object)state.getValue(PART));
            if (part != Part.MIDDLE && !player.isCreative()) {
                BlockPos middlePos = part == Part.BOTTOM ? position.above() : position.below();
                BlockState middleState = level.getBlockState(middlePos);
                if (middleState.getBlock() == state.getBlock()) {
                    level.setBlock(middlePos, Blocks.AIR.defaultBlockState(), 35);
                    level.levelEvent(player, 2001, middlePos, Block.getId((BlockState)middleState));
                }
            } else if (part != Part.BOTTOM && player.isCreative() && (bottomState = level.getBlockState(bottomPos = part == Part.MIDDLE ? position.below() : position.below(2))).getBlock() == state.getBlock()) {
                level.setBlock(bottomPos, Blocks.AIR.defaultBlockState(), 35);
                level.levelEvent(player, 2001, bottomPos, Block.getId((BlockState)bottomState));
            }
        }
        return super.playerWillDestroy(level, position, state, player);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, FACING, OPEN, HINGE, POWERED, WATERLOGGED});
    }

    public static enum Part implements StringRepresentable
    {
        BOTTOM,
        MIDDLE,
        TOP;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

