/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.commands.arguments;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ManaHandling;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ResourceLocationException;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DragonSpeciesArgument
implements ArgumentType<Holder<DragonSpecies>> {
    public static final String ID = "dragon_species";
    public static final DragonSpecies EMPTY = new DragonSpecies(Optional.empty(), Optional.empty(), ManaHandling.DEFAULT, Optional.empty(), (HolderSet<DragonBody>)HolderSet.empty(), (HolderSet<DragonAbility>)HolderSet.empty(), (HolderSet<DragonPenalty>)HolderSet.empty(), null);
    private static final ResourceLocation HUMAN = DragonSurvival.res("human");
    private final HolderLookup.RegistryLookup<DragonSpecies> lookup;

    public DragonSpeciesArgument(CommandBuildContext context) {
        this.lookup = context.lookupOrThrow(DragonSpecies.REGISTRY);
    }

    @Nullable
    public Holder<DragonSpecies> parse(StringReader reader) throws CommandSyntaxException {
        try {
            int start = reader.getCursor();
            ResourceLocation species = ResourceLocation.read((StringReader)reader);
            if (species.equals((Object)HUMAN)) {
                return Holder.direct((Object)EMPTY);
            }
            Optional optional = this.lookup.get(ResourceKey.create(DragonSpecies.REGISTRY, (ResourceLocation)species));
            if (optional.isEmpty()) {
                reader.setCursor(start);
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext((ImmutableStringReader)reader);
            }
            return (Holder)optional.get();
        }
        catch (ResourceLocationException exception) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext((ImmutableStringReader)reader);
        }
    }

    public static Holder<DragonSpecies> get(CommandContext<?> context) {
        return (Holder)context.getArgument(ID, Holder.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ArrayList<String> suggestions = new ArrayList<String>();
        this.lookup.listElementIds().forEach(element -> suggestions.add(element.location().toString()));
        if (!ServerConfig.noHumansAllowed.booleanValue()) {
            suggestions.add(HUMAN.toString());
        }
        return SharedSuggestionProvider.suggest(suggestions, (SuggestionsBuilder)builder);
    }
}

