/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.commands;

import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public class ClearModifiersCommand {
    @Translation(comments={"%s modifiers cleared from %s entities."})
    private static final String FROM_ENTITES = Translation.Type.COMMAND.wrap("clear_modifiers.from_entities");
    @Translation(comments={"%s modifiers cleared from %s."})
    private static final String FROM_SINGLE_ENTITY = Translation.Type.COMMAND.wrap("clear_modifiers.from_single_entity");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dragon-modifiers").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(source -> ClearModifiersCommand.clearModifiers((CommandSourceStack)source.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandSourceStack)source.getSource()).getEntityOrException())))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(source -> ClearModifiersCommand.clearModifiers((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"targets"))))));
    }

    private static int clearModifiers(CommandSourceStack source, Collection<? extends Entity> targets) {
        AtomicInteger totalRemoved = new AtomicInteger();
        for (Entity entity : targets) {
            DSDataAttachments.getStorages(entity).forEach(storage -> {
                storage.clear(target);
                totalRemoved.getAndIncrement();
            });
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)FROM_SINGLE_ENTITY, (Object[])new Object[]{totalRemoved.get(), ((Entity)targets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)FROM_ENTITES, (Object[])new Object[]{totalRemoved.get(), targets.size()}), true);
        }
        return 1;
    }
}

