/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.commands;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ClearMarkCommand {
    @Translation(comments={"Mark cleared from %s players."})
    private static final String FROM_PLAYERS = Translation.Type.COMMAND.wrap("clear_mark.from_players");
    @Translation(comments={"Mark cleared from %s."})
    private static final String FROM_SINGLE_PLAYER = Translation.Type.COMMAND.wrap("clear_mark.from_single_player");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dragon-mark").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(commandSourceStack -> ClearMarkCommand.clearMark((CommandSourceStack)commandSourceStack.getSource(), List.of(((CommandSourceStack)commandSourceStack.getSource()).getPlayerOrException())))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(commandSourceStack -> ClearMarkCommand.clearMark((CommandSourceStack)commandSourceStack.getSource(), EntityArgument.getPlayers((CommandContext)commandSourceStack, (String)"targets"))))));
    }

    private static int clearMark(CommandSourceStack source, Collection<? extends Player> targets) {
        for (Player player : targets) {
            DragonStateProvider.getData((Player)player).markedByEnderDragon = false;
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)FROM_SINGLE_PLAYER, (Object[])new Object[]{((Player)targets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)FROM_PLAYERS, (Object[])new Object[]{targets.size()}), true);
        }
        return 1;
    }
}

