/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects;

import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.SkinLayer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.loader.DefaultPartLoader;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.loader.DragonPartLoader;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonPart;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.LayerSettings;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import com.mojang.datafixers.util.Either;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;

public class DragonStageCustomization
implements INBTSerializable<CompoundTag> {
    public static final String HAS_WINGS = "wings";
    public static final String IS_DEFAULT_SKIN = "defaultSkin";
    public final HashMap<SkinLayer, Lazy<LayerSettings>> layerSettings = new HashMap();
    public boolean wings = true;
    public boolean defaultSkin;

    public DragonStageCustomization(ResourceKey<DragonStage> stage, ResourceKey<DragonSpecies> species, ResourceLocation customModel) {
        this();
        for (SkinLayer layer : SkinLayer.values()) {
            String partKey;
            SkinLayer actualLayer = SkinLayer.valueOf(layer.getNameUpperCase());
            Map<String, DragonPart> parts = DragonPartLoader.getDragonParts(actualLayer, species, null);
            DragonPart defaultPart = parts.get(partKey = DefaultPartLoader.getDefaultPartKey(species, stage, (Either<ResourceKey<DragonBody>, ResourceLocation>)Either.right((Object)customModel), layer));
            if (defaultPart != null) {
                this.layerSettings.put(layer, (Lazy<LayerSettings>)Lazy.of(() -> new LayerSettings(partKey, defaultPart.averageHue())));
                continue;
            }
            this.layerSettings.put(layer, (Lazy<LayerSettings>)Lazy.of(() -> new LayerSettings(partKey, 0.5f)));
        }
    }

    public DragonStageCustomization() {
        for (SkinLayer layer : SkinLayer.values()) {
            this.layerSettings.computeIfAbsent(layer, key -> Lazy.of(LayerSettings::new));
        }
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag layerData = new CompoundTag();
        layerData.putBoolean(HAS_WINGS, this.wings);
        layerData.putBoolean(IS_DEFAULT_SKIN, this.defaultSkin);
        for (SkinLayer layer : SkinLayer.values()) {
            layerData.put(layer.name(), (Tag)((LayerSettings)this.layerSettings.getOrDefault((Object)layer, (Lazy<LayerSettings>)Lazy.of(LayerSettings::new)).get()).serializeNBT(provider));
        }
        return layerData;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        this.wings = tag.getBoolean(HAS_WINGS);
        this.defaultSkin = tag.getBoolean(IS_DEFAULT_SKIN);
        for (SkinLayer layer : SkinLayer.values()) {
            this.layerSettings.put(layer, (Lazy<LayerSettings>)Lazy.of(() -> {
                LayerSettings settings = new LayerSettings();
                CompoundTag layerData = tag.getCompound(layer.name());
                settings.deserializeNBT(provider, layerData);
                return settings;
            }));
        }
    }
}

