/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.loader;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.SkinLayer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DefaultPart;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultPartLoader
extends SimpleJsonResourceReloadListener {
    public static final String NO_PART = "none";
    private static final Map<ResourceKey<DragonBody>, Map<ResourceKey<DragonSpecies>, Map<ResourceKey<DragonStage>, HashMap<SkinLayer, String>>>> PARTY_BY_BODY = new HashMap<ResourceKey<DragonBody>, Map<ResourceKey<DragonSpecies>, Map<ResourceKey<DragonStage>, HashMap<SkinLayer, String>>>>();
    private static final Map<ResourceLocation, Map<ResourceKey<DragonSpecies>, Map<ResourceKey<DragonStage>, HashMap<SkinLayer, String>>>> PARTY_BY_MODEL = new HashMap<ResourceLocation, Map<ResourceKey<DragonSpecies>, Map<ResourceKey<DragonStage>, HashMap<SkinLayer, String>>>>();

    public DefaultPartLoader() {
        super(new Gson(), "skin/default_parts");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        PARTY_BY_MODEL.clear();
        map.forEach((location, value) -> {
            DataResult result = DefaultPart.CODEC.decode((DynamicOps)JsonOps.INSTANCE, value).ifError(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).map(Pair::getFirst);
            if (!result.isSuccess()) {
                return;
            }
            DefaultPart part = (DefaultPart)result.getOrThrow();
            if (part.body().isPresent()) {
                PARTY_BY_BODY.computeIfAbsent(part.body().get(), key -> new HashMap()).computeIfAbsent(part.species(), key -> new HashMap()).computeIfAbsent(part.stage(), key -> new HashMap()).putAll(part.parts());
            } else if (part.model().isPresent()) {
                PARTY_BY_MODEL.computeIfAbsent(part.model().get(), key -> new HashMap()).computeIfAbsent(part.species(), key -> new HashMap()).computeIfAbsent(part.stage(), key -> new HashMap()).putAll(part.parts());
            }
        });
    }

    @Nullable
    public static String getDefaultPartKey(ResourceKey<DragonSpecies> species, ResourceKey<DragonStage> stage, Either<ResourceKey<DragonBody>, ResourceLocation> partsKey, SkinLayer layer) {
        Map entries = (Map)partsKey.map(PARTY_BY_BODY::get, PARTY_BY_MODEL::get);
        if (entries == null) {
            return NO_PART;
        }
        Map perSpecies = (Map)entries.get(species);
        if (perSpecies == null) {
            return NO_PART;
        }
        HashMap perStage = (HashMap)perSpecies.get(stage);
        if (perStage == null) {
            return NO_PART;
        }
        return perStage.getOrDefault((Object)layer, NO_PART);
    }
}

