/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.models.DragonModel;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.SkinLayer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.loader.DragonPartLoader;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonPart;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonStageCustomization;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.LayerSettings;
import by.dragonsurvivalteam.dragonsurvival.client.util.RenderingUtils;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.GlStateBackup;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class DragonEditorHandler {
    private static ShaderInstance skinGenerationShader;

    public static void generateSkinTextures(DragonEntity dragon) {
        Player player = dragon.getPlayer();
        if (player == null) {
            return;
        }
        DragonStateHandler handler = DragonStateProvider.getData(player);
        DragonBody.TextureSize textureSize = ((DragonBody)handler.body().value()).textureSize();
        GlStateBackup state = new GlStateBackup();
        RenderSystem.backupGlState((GlStateBackup)state);
        RenderSystem.backupProjectionMatrix();
        int currentFrameBuffer = GlStateManager.getBoundFramebuffer();
        int currentViewportX = GlStateManager.Viewport.x();
        int currentViewportY = GlStateManager.Viewport.y();
        int currentViewportWidth = GlStateManager.Viewport.width();
        int currentViewportHeight = GlStateManager.Viewport.height();
        TextureTarget normalTarget = new TextureTarget(textureSize.width(), textureSize.height(), false, Minecraft.ON_OSX);
        TextureTarget glowTarget = new TextureTarget(textureSize.width(), textureSize.height(), false, Minecraft.ON_OSX);
        normalTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        glowTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        normalTarget.clear(true);
        glowTarget.clear(true);
        DragonStageCustomization customization = handler.getCurrentStageCustomization();
        for (SkinLayer layer : SkinLayer.values()) {
            DragonPart skinTexture;
            LayerSettings settings = (LayerSettings)customization.layerSettings.get((Object)layer).get();
            String partKey = settings.partKey;
            if (partKey == null || (skinTexture = DragonPartLoader.getDragonPart(layer, handler.speciesKey(), handler.body(), partKey)) == null) continue;
            float hueVal = settings.hue - skinTexture.averageHue();
            float satVal = settings.saturation;
            float brightVal = settings.brightness;
            DragonPart part = DragonPartLoader.getDragonPart(layer, handler.speciesKey(), handler.body(), partKey);
            if (part == null) continue;
            AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(part.texture());
            if (settings.glowing) {
                glowTarget.bindWrite(true);
            } else {
                normalTarget.bindWrite(true);
            }
            RenderSystem.enableBlend();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.blendEquation((int)32774);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            skinGenerationShader.setSampler("SkinTexture", (Object)texture);
            skinGenerationShader.getUniform("HueVal").set(hueVal);
            skinGenerationShader.getUniform("SatVal").set(satVal);
            skinGenerationShader.getUniform("BrightVal").set(brightVal);
            skinGenerationShader.getUniform("Colorable").set(skinTexture.isColorable() ? 1.0f : 0.0f);
            skinGenerationShader.getUniform("Glowing").set(settings.glowing ? 1.0f : 0.0f);
            skinGenerationShader.apply();
            BufferBuilder bufferbuilder = RenderSystem.renderThreadTesselator().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLIT_SCREEN);
            bufferbuilder.addVertex(0.0f, 0.0f, 0.0f);
            bufferbuilder.addVertex(1.0f, 0.0f, 0.0f);
            bufferbuilder.addVertex(1.0f, 1.0f, 0.0f);
            bufferbuilder.addVertex(0.0f, 1.0f, 0.0f);
            BufferUploader.draw((MeshData)bufferbuilder.buildOrThrow());
            if (settings.glowing && layer == SkinLayer.BASE) {
                normalTarget.bindWrite(true);
                bufferbuilder = RenderSystem.renderThreadTesselator().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLIT_SCREEN);
                bufferbuilder.addVertex(0.0f, 0.0f, 0.0f);
                bufferbuilder.addVertex(1.0f, 0.0f, 0.0f);
                bufferbuilder.addVertex(1.0f, 1.0f, 0.0f);
                bufferbuilder.addVertex(0.0f, 1.0f, 0.0f);
                BufferUploader.draw((MeshData)bufferbuilder.buildOrThrow());
                normalTarget.unbindWrite();
            }
            skinGenerationShader.clear();
            if (settings.glowing) {
                glowTarget.unbindWrite();
                continue;
            }
            normalTarget.unbindWrite();
        }
        RenderingUtils.copyTextureFromRenderTarget((RenderTarget)normalTarget, DragonModel.dynamicTexture(player, handler, false));
        RenderingUtils.copyTextureFromRenderTarget((RenderTarget)glowTarget, DragonModel.dynamicTexture(player, handler, true));
        glowTarget.destroyBuffers();
        normalTarget.destroyBuffers();
        RenderSystem.restoreGlState((GlStateBackup)state);
        RenderSystem.restoreProjectionMatrix();
        GlStateManager._glBindFramebuffer((int)36160, (int)currentFrameBuffer);
        GlStateManager._viewport((int)currentViewportX, (int)currentViewportY, (int)currentViewportWidth, (int)currentViewportHeight);
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), DragonSurvival.res("skin_generation"), DefaultVertexFormat.BLIT_SCREEN), instance -> {
            skinGenerationShader = instance;
        });
    }
}

