/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon;

import by.dragonsurvivalteam.dragonsurvival.client.models.DragonModel;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonStageCustomization;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.LayerSettings;
import by.dragonsurvivalteam.dragonsurvival.client.skins.DragonSkins;
import by.dragonsurvivalteam.dragonsurvival.client.util.RenderingUtils;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.StageResources;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class DragonGlowLayerRenderer
extends GeoRenderLayer<DragonEntity> {
    private final GeoEntityRenderer<DragonEntity> renderer;

    public DragonGlowLayerRenderer(GeoEntityRenderer<DragonEntity> renderer) {
        super(renderer);
        this.renderer = renderer;
    }

    public void render(PoseStack poseStack, DragonEntity animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        GeoEntityRenderer<DragonEntity> geoEntityRenderer = this.renderer;
        if (!(geoEntityRenderer instanceof DragonRenderer)) {
            return;
        }
        DragonRenderer dragonRenderer = (DragonRenderer)geoEntityRenderer;
        if (!dragonRenderer.shouldRenderLayers) {
            return;
        }
        Object player = animatable.overrideUUIDWithLocalPlayerForTextureFetch ? Minecraft.getInstance().player : animatable.getPlayer();
        if (player == null) {
            return;
        }
        DragonStateHandler handler = DragonStateProvider.getData((Player)player);
        DragonStageCustomization customization = handler.getCurrentStageCustomization();
        ResourceLocation glowTexture = null;
        if (handler.getModel().equals((Object)DragonBody.DEFAULT_MODEL)) {
            glowTexture = DragonSkins.getGlowTexture((Player)player, handler.stageKey());
        }
        if (dragonRenderer.glowTexture != null && (glowTexture == null || glowTexture.getPath().contains("/" + handler.speciesId().getPath() + "_"))) {
            glowTexture = dragonRenderer.glowTexture;
        }
        if (glowTexture == null && handler.getCurrentStageCustomization().defaultSkin) {
            ResourceLocation defaultGlowSkin = StageResources.getDefaultSkin(handler.species(), handler.stageKey(), true);
            if (Minecraft.getInstance().getResourceManager().getResource(defaultGlowSkin).isPresent()) {
                glowTexture = defaultGlowSkin;
            }
        }
        dragonRenderer.isRenderingLayer = true;
        if (glowTexture == null && customization.layerSettings.values().stream().anyMatch(layerSettings -> ((LayerSettings)layerSettings.get()).glowing)) {
            glowTexture = DragonModel.dynamicTexture((Player)player, handler, true);
        }
        if (glowTexture != null && RenderingUtils.hasTexture(glowTexture)) {
            RenderType type = (RenderType)RenderType.EYES.apply(glowTexture, RenderType.LIGHTNING_TRANSPARENCY);
            dragonRenderer.actuallyRender(poseStack, animatable, bakedModel, type, bufferSource, bufferSource.getBuffer(type), true, partialTick, packedLight, OverlayTexture.NO_OVERLAY, this.renderer.getRenderColor((Entity)animatable, partialTick, packedLight).getColor());
        }
        dragonRenderer.isRenderingLayer = false;
    }
}

