/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.ClawsAndTeeth;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.util.RenderingUtils;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.compat.car.CosmeticArmorReworkedHelper;
import by.dragonsurvivalteam.dragonsurvival.compat.curios.CurioAPIHelper;
import by.dragonsurvivalteam.dragonsurvival.compat.iris.InnerWrappedRenderType;
import by.dragonsurvivalteam.dragonsurvival.compat.iris.LayeringStates;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ClawInventoryData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSItemTags;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.DyedItemColor;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class DragonArmorRenderLayer
extends GeoRenderLayer<DragonEntity> {
    private final GeoEntityRenderer<DragonEntity> renderer;
    private static final HashMap<ResourceLocation, CompletableFuture<Void>> armorTextures = new HashMap();
    private static final HashMap<ResourceLocation, HashMap<EquipmentSlot, NativeImage>> armorMasksPerModel = new HashMap();

    public DragonArmorRenderLayer(GeoEntityRenderer<DragonEntity> renderer) {
        super(renderer);
        this.renderer = renderer;
    }

    private void initArmorMasks(ResourceLocation model) {
        armorMasksPerModel.computeIfAbsent(model, key -> {
            HashMap<EquipmentSlot, NativeImage> masks = new HashMap<EquipmentSlot, NativeImage>();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
                String texture = "textures/armor/" + key.getPath() + "/armor_trims/masks/" + slot.getName() + "_mask.png";
                ResourceLocation resource = ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)texture);
                Optional armorFile = Minecraft.getInstance().getResourceManager().getResource(resource);
                if (armorFile.isEmpty()) {
                    DragonSurvival.LOGGER.error("Armor mask {} missing for model {}", (Object)texture, (Object)model.getPath());
                    continue;
                }
                try {
                    InputStream textureStream = ((Resource)armorFile.get()).open();
                    masks.put(slot, NativeImage.read((InputStream)textureStream));
                    textureStream.close();
                }
                catch (IOException exception) {
                    DragonSurvival.LOGGER.error("Failed to read file {}", (Object)texture, (Object)exception);
                }
            }
            return masks;
        });
    }

    public void render(PoseStack poseStack, DragonEntity animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        Optional<ResourceLocation> armorTexture;
        Player player = animatable.getPlayer();
        if (player == null) {
            return;
        }
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (!armorMasksPerModel.containsKey(handler.getModel())) {
            this.initArmorMasks(handler.getModel());
        }
        if ((DragonArmorRenderLayer.hasAnyArmorEquipped(player) || ClawInventoryData.getData((Player)player).shouldRenderClaws) && (armorTexture = DragonArmorRenderLayer.constructTrimmedDragonArmorTexture(player)).isPresent()) {
            ((DragonRenderer)this.renderer).isRenderingLayer = true;
            this.renderArmor(poseStack, animatable, bakedModel, bufferSource, partialTick, packedLight, armorTexture.get());
            ((DragonRenderer)this.renderer).isRenderingLayer = false;
        }
    }

    private void renderArmor(PoseStack poseStack, DragonEntity animatable, BakedGeoModel bakedModel, MultiBufferSource bufferSource, float partialTick, int packedLight, ResourceLocation texture) {
        if (animatable == null) {
            return;
        }
        ClientDragonRenderer.dragonModel.setOverrideTexture(texture);
        RenderType type = this.renderer.getRenderType((Entity)animatable, texture, bufferSource, partialTick);
        if (type != null) {
            InnerWrappedRenderType wrappedType = new InnerWrappedRenderType("dragon_armor", type, (RenderStateShard)LayeringStates.VIEW_OFFSET_Z_LAYERING_FORWARD);
            VertexConsumer vertexConsumer = bufferSource.getBuffer((RenderType)wrappedType);
            this.renderer.actuallyRender(poseStack, (Entity)animatable, bakedModel, (RenderType)wrappedType, bufferSource, vertexConsumer, true, partialTick, packedLight, OverlayTexture.NO_OVERLAY, this.renderer.getRenderColor((Entity)animatable, partialTick, packedLight).getColor());
        }
        ClientDragonRenderer.dragonModel.setOverrideTexture(null);
    }

    private static Optional<ResourceLocation> constructTrimmedDragonArmorTexture(Player player) {
        String armorUUID = DragonArmorRenderLayer.buildUniqueArmorUUID(player);
        ResourceLocation imageResource = DragonSurvival.res("armor_" + armorUUID);
        if (armorTextures.containsKey(imageResource)) {
            CompletableFuture<Void> future = armorTextures.get(imageResource);
            if (future.isDone()) {
                return Optional.of(imageResource);
            }
        } else {
            CompletionStage uploadStep = CompletableFuture.supplyAsync(() -> DragonArmorRenderLayer.compileArmorTexture(player)).thenAcceptAsync(image -> RenderingUtils.uploadTexture(image, imageResource), (Executor)Minecraft.getInstance());
            armorTextures.put(imageResource, (CompletableFuture<Void>)uploadStep);
        }
        return Optional.empty();
    }

    private static NativeImage compileArmorTexture(Player player) {
        ArrayList<ItemStack> visibleCurios;
        DragonStateHandler handler = DragonStateProvider.getData(player);
        ResourceLocation currentDragonModel = handler.getModel();
        DragonBody.TextureSize textureSize = ((DragonBody)handler.body().value()).textureSize();
        if (!armorMasksPerModel.containsKey(currentDragonModel)) {
            return new NativeImage(textureSize.width(), textureSize.height(), true);
        }
        HashMap<EquipmentSlot, NativeImage> armorMasks = armorMasksPerModel.get(currentDragonModel);
        if (armorMasks.isEmpty()) {
            return new NativeImage(textureSize.width(), textureSize.height(), true);
        }
        NativeImage image = new NativeImage(armorMasks.values().stream().findFirst().get().getWidth(), armorMasks.values().stream().findFirst().get().getHeight(), true);
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (!armorMasks.containsKey(equipmentSlot)) continue;
            ItemStack stack = CosmeticArmorReworkedHelper.getItemVisibleInSlot(player, equipmentSlot);
            ResourceLocation existingArmorLocation = DragonArmorRenderLayer.generateArmorTextureResourceLocation(player, equipmentSlot);
            NativeImage armorImage = RenderingUtils.getImageFromResource(existingArmorLocation);
            if (stack.getItem() instanceof ArmorItem) {
                if (armorImage == null) continue;
                if (armorImage.getWidth() != image.getWidth() || armorImage.getHeight() != image.getHeight()) {
                    DragonSurvival.LOGGER.error("Armor texture {} does not match the expected size of {}x{} given by the mask!", (Object)existingArmorLocation, (Object)image.getWidth(), (Object)image.getHeight());
                    armorImage.close();
                    continue;
                }
                ArmorTrim trim = (ArmorTrim)stack.get(DataComponents.TRIM);
                boolean hasTrim = false;
                float[] trimBaseHSB = new float[3];
                if (trim != null) {
                    hasTrim = true;
                    ResourceLocation paletteResource = ResourceLocation.withDefaultNamespace((String)("textures/trims/color_palettes/" + ((TrimMaterial)trim.material().value()).assetName() + ".png"));
                    NativeImage colorPalette = RenderingUtils.getImageFromResource(paletteResource);
                    if (colorPalette != null) {
                        int[] baseRed = new int[colorPalette.getWidth() * colorPalette.getHeight()];
                        int[] baseGreen = new int[colorPalette.getWidth() * colorPalette.getHeight()];
                        int[] baseBlue = new int[colorPalette.getWidth() * colorPalette.getHeight()];
                        int red = 0;
                        int green = 0;
                        int blue = 0;
                        int z = 0;
                        for (int x = 0; x < colorPalette.getWidth(); ++x) {
                            for (int y = 0; y < colorPalette.getHeight(); ++y) {
                                int rgba = colorPalette.getPixelRGBA(x, y);
                                if (rgba == 0) continue;
                                Color c = new Color(rgba);
                                baseRed[z] = c.getRed();
                                baseGreen[z] = c.getGreen();
                                baseBlue[z] = c.getBlue();
                                ++z;
                            }
                        }
                        for (int i = 0; i < z; ++i) {
                            red += baseRed[i];
                            green += baseGreen[i];
                            blue += baseBlue[i];
                        }
                        trimBaseColor = new Color(blue / z, green / z, red / z, 255);
                        Color.RGBtoHSB(trimBaseColor.getBlue(), trimBaseColor.getGreen(), trimBaseColor.getRed(), trimBaseHSB);
                        colorPalette.close();
                    } else {
                        TextColor textColor = ((TrimMaterial)trim.material().value()).description().getStyle().getColor();
                        if (textColor != null) {
                            trimBaseColor = new Color(textColor.getValue());
                            Color.RGBtoHSB(trimBaseColor.getBlue(), trimBaseColor.getGreen(), trimBaseColor.getRed(), trimBaseHSB);
                        }
                    }
                }
                float[] armorHSB = new float[3];
                float[] trimHSB = new float[3];
                float[] dyeHSB = new float[3];
                DyedItemColor dyeColor = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
                if (dyeColor != null) {
                    Color armorDye = new Color(dyeColor.rgb());
                    Color.RGBtoHSB(armorDye.getBlue(), armorDye.getGreen(), armorDye.getRed(), dyeHSB);
                }
                NativeImage trimImage = null;
                if (hasTrim) {
                    String patternPath = ((TrimPattern)trim.pattern().value()).assetId().getPath();
                    String texture = "textures/armor/" + handler.getModel().getPath() + "/armor_trims/" + patternPath + ".png";
                    ResourceLocation resource = ResourceLocation.fromNamespaceAndPath((String)handler.getModel().getNamespace(), (String)texture);
                    trimImage = RenderingUtils.getImageFromResource(resource);
                }
                for (int x = 0; x < armorImage.getWidth(); ++x) {
                    for (int y = 0; y < armorImage.getHeight(); ++y) {
                        if (armorMasks.get(equipmentSlot).getPixelRGBA(x, y) == 0) continue;
                        Color armorColor = new Color(armorImage.getPixelRGBA(x, y), true);
                        if (hasTrim && trimImage != null) {
                            Color trimColor = new Color(trimImage.getPixelRGBA(x, y), true);
                            Color.RGBtoHSB(trimColor.getRed(), trimColor.getGreen(), trimColor.getBlue(), trimHSB);
                            if (trimColor.getAlpha() != 0) {
                                if (trimHSB[1] != 0.0f) continue;
                                image.setPixelRGBA(x, y, Color.HSBtoRGB(trimBaseHSB[0], trimBaseHSB[1], trimHSB[2]));
                                continue;
                            }
                            if (armorColor.getAlpha() == 0) continue;
                            if (dyeHSB[0] != 0.0f && dyeHSB[1] != 0.0f) {
                                image.setPixelRGBA(x, y, Color.HSBtoRGB(dyeHSB[0], dyeHSB[1], Color.RGBtoHSB(armorColor.getRed(), armorColor.getGreen(), armorColor.getBlue(), null)[1]));
                                continue;
                            }
                            image.setPixelRGBA(x, y, armorColor.getRGB());
                            continue;
                        }
                        if (armorColor.getAlpha() == 0) continue;
                        Color.RGBtoHSB(armorColor.getRed(), armorColor.getGreen(), armorColor.getBlue(), armorHSB);
                        if ((dyeHSB[0] != 0.0f || dyeHSB[1] != 0.0f) && armorHSB[1] == 0.0f) {
                            image.setPixelRGBA(x, y, Color.HSBtoRGB(dyeHSB[0], dyeHSB[1], armorHSB[2]));
                            continue;
                        }
                        image.setPixelRGBA(x, y, armorColor.getRGB());
                    }
                }
                armorImage.close();
                if (trimImage == null) continue;
                trimImage.close();
                continue;
            }
            DragonArmorRenderLayer.copyPixels(image, armorImage);
        }
        if (ClawInventoryData.getData((Player)player).shouldRenderClaws) {
            ResourceLocation teethResource;
            ResourceLocation clawResource = ClawsAndTeeth.constructClawTexture(player);
            if (clawResource != null) {
                DragonArmorRenderLayer.copyPixels(image, RenderingUtils.getImageFromResource(clawResource));
            }
            if ((teethResource = ClawsAndTeeth.constructTeethTexture(player)) != null) {
                DragonArmorRenderLayer.copyPixels(image, RenderingUtils.getImageFromResource(teethResource));
            }
        }
        if ((visibleCurios = CurioAPIHelper.getVisibleCurioItems(player)) != null) {
            for (ItemStack itemStack : visibleCurios) {
                ResourceLocation curioResource = DragonArmorRenderLayer.toArmorResource(handler.getModel(), itemStack.getItem());
                if (curioResource == null || !Minecraft.getInstance().getResourceManager().getResource(curioResource).isPresent()) continue;
                DragonArmorRenderLayer.copyPixels(image, RenderingUtils.getImageFromResource(curioResource));
            }
        }
        return image;
    }

    private static void copyPixels(NativeImage destination, NativeImage source) {
        if (source != null) {
            for (int x = 0; x < source.getWidth(); ++x) {
                for (int y = 0; y < source.getHeight(); ++y) {
                    int pixel = source.getPixelRGBA(x, y);
                    if (pixel == 0) continue;
                    destination.setPixelRGBA(x, y, pixel);
                }
            }
            source.close();
        }
    }

    private static boolean hasAnyArmorEquipped(Player player) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!slot.isArmor() || player.getItemBySlot(slot).is(Items.AIR)) continue;
            return true;
        }
        return false;
    }

    private static String buildUniqueArmorUUID(Player player) {
        ArrayList<ItemStack> visibleCurios;
        StringBuilder armorTotal = new StringBuilder();
        String separator = "/";
        armorTotal.append(DragonStateProvider.getData(player).getModel().toLanguageKey());
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            DyedItemColor dyeColor;
            if (!equipmentSlot.isArmor()) continue;
            ItemStack stack = CosmeticArmorReworkedHelper.getItemVisibleInSlot(player, equipmentSlot);
            armorTotal.append(separator).append(separator).append(stack.getItemHolder().getKey().location().toLanguageKey());
            ArmorTrim trim = (ArmorTrim)stack.getComponents().get(DataComponents.TRIM);
            if (trim != null) {
                armorTotal.append(separator).append(((TrimMaterial)trim.material().value()).assetName()).append(separator).append(((TrimPattern)trim.pattern().value()).assetId());
            }
            if ((dyeColor = (DyedItemColor)stack.get(DataComponents.DYED_COLOR)) == null) continue;
            armorTotal.append(separator).append(dyeColor.rgb());
        }
        if (ClawInventoryData.getData((Player)player).shouldRenderClaws) {
            armorTotal.append(separator).append(ClawsAndTeeth.constructClawTexture(player)).append(separator).append(ClawsAndTeeth.constructTeethTexture(player));
        }
        if ((visibleCurios = CurioAPIHelper.getVisibleCurioItems(player)) != null) {
            for (ItemStack curio : visibleCurios) {
                armorTotal.append(separator).append(curio.getDisplayName());
            }
        }
        return UUID.nameUUIDFromBytes(armorTotal.toString().getBytes()).toString();
    }

    private static ResourceLocation generateArmorTextureResourceLocation(Player player, EquipmentSlot equipmentSlot) {
        DragonStateHandler handler = DragonStateProvider.getData(player);
        Item item = CosmeticArmorReworkedHelper.getItemVisibleInSlot(player, equipmentSlot).getItem();
        ResourceLocation armorResource = DragonArmorRenderLayer.toArmorResource(handler.getModel(), item);
        if (armorResource != null && Minecraft.getInstance().getResourceManager().getResource(armorResource).isPresent()) {
            return armorResource;
        }
        String texture = "textures/armor/" + handler.getModel().getPath() + "/";
        if (item instanceof ArmorItem) {
            Holder.Reference holder;
            ArmorItem armorItem = (ArmorItem)item;
            ResourceLocation materialResource = armorItem.getMaterial().getKey().location();
            texture = texture + materialResource.getNamespace() + "/materials/" + materialResource.getPath() + "/" + equipmentSlot.getName();
            if (armorItem.getMaterial() == ArmorMaterials.LEATHER && player.getItemBySlot(equipmentSlot).get(DataComponents.DYED_COLOR) == null) {
                texture = texture + "_undyed";
            }
            ResourceLocation resource = ResourceLocation.fromNamespaceAndPath((String)handler.getModel().getNamespace(), (String)(texture + ".png"));
            if (Minecraft.getInstance().getResourceManager().getResource(resource).isPresent()) {
                return resource;
            }
            if (materialResource.getNamespace().equals("minecraft")) {
                DragonSurvival.LOGGER.warn("Missing vanilla armor texture for {} in model {}, falling back to generic armor.", (Object)resource.getPath(), (Object)handler.getModel().getPath());
            }
            String prefix = (holder = item.builtInRegistryHolder()).is(DSItemTags.EPIC_ARMOR) ? "epic" : (holder.is(DSItemTags.RARE_ARMOR) ? "rare" : (holder.is(DSItemTags.UNCOMMON_ARMOR) ? "uncommon" : "default"));
            return ResourceLocation.fromNamespaceAndPath((String)handler.getModel().getNamespace(), (String)("textures/armor/" + handler.getModel().getPath() + "/" + prefix + "_" + equipmentSlot.getName() + ".png"));
        }
        return DragonSurvival.res("textures/armor/empty_armor.png");
    }

    private static ResourceLocation toArmorResource(ResourceLocation model, Item item) {
        if (item == Items.AIR) {
            return null;
        }
        ResourceLocation itemResource = item.builtInRegistryHolder().getKey().location();
        String texture = "textures/armor/" + model.getPath() + "/" + itemResource.getNamespace() + "/" + itemResource.getPath() + ".png";
        return ResourceLocation.fromNamespaceAndPath((String)model.getNamespace(), (String)texture);
    }
}

