/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.entity;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.capability.EntityStateHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.GlStateBackup;
import org.joml.Matrix4f;

public class PillageIconRenderer {
    private static final ResourceLocation ICON = DragonSurvival.res("textures/icons/pillage_icon.png");
    private static final int SIZE = 16;

    public static void renderIcon(Entity entity, PoseStack poseStack, double distance) {
        if (ServerConfig.MAX_RENDER_DISTANCE == 0 || distance > (double)(ServerConfig.MAX_RENDER_DISTANCE * ServerConfig.MAX_RENDER_DISTANCE)) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (entity.isInvisible()) {
            return;
        }
        if (!PillageIconRenderer.shouldRenderIcon(livingEntity)) {
            return;
        }
        GlStateBackup state = new GlStateBackup();
        RenderSystem.backupGlState((GlStateBackup)state);
        float scale = 0.025f * livingEntity.getScale();
        float y = -12.0f;
        float x = -8.0f;
        poseStack.pushPose();
        poseStack.translate(0.0, (double)entity.getBbHeight() + 0.5, 0.0);
        poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(scale, -scale, scale);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        Matrix4f matrix = poseStack.last().pose();
        Minecraft.getInstance().getTextureManager().getTexture(ICON).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buffer.addVertex(matrix, x, y + 16.0f, 0.0f).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(matrix, x + 16.0f, y + 16.0f, 0.0f).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(matrix, x + 16.0f, y, 0.0f).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(matrix, x, y, 0.0f).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        MeshData data = buffer.build();
        if (data != null) {
            BufferUploader.drawWithShader((MeshData)data);
        }
        poseStack.popPose();
        RenderSystem.restoreGlState((GlStateBackup)state);
    }

    private static boolean shouldRenderIcon(LivingEntity entity) {
        if (entity.isBaby()) {
            return false;
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            VillagerProfession profession = villager.getVillagerData().getProfession();
            if (profession == VillagerProfession.NONE || profession == VillagerProfession.NITWIT) {
                return false;
            }
            return EntityStateHandler.canPillage((Entity)villager, (Player)Minecraft.getInstance().player);
        }
        return false;
    }
}

