/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.blocks;

import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.HelmetBlockEntity;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HelmetEntityRenderer
implements BlockEntityRenderer<HelmetBlockEntity> {
    private static final Map<Block, ResourceLocation> TEXTURE_BY_TYPE = (Map)Util.make((Object)Maps.newHashMap(), resourceLocationHashMap -> {
        resourceLocationHashMap.put((Block)DSBlocks.GRAY_KNIGHT_HELMET.get(), ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/block/gray_knight_helmet.png"));
        resourceLocationHashMap.put((Block)DSBlocks.GOLDEN_KNIGHT_HELMET.get(), ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/block/golden_knight_helmet.png"));
        resourceLocationHashMap.put((Block)DSBlocks.BLACK_KNIGHT_HELMET.get(), ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/block/black_knight_helmet.png"));
    });
    static SkullModel humanoidHeadModel = new SkullModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER_HEAD));

    public HelmetEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(HelmetBlockEntity helmetEntity, float partialTick, @NotNull PoseStack PoseStack2, @NotNull MultiBufferSource renderTypeBuffer, int packedLight, int packedOverlay) {
        BlockState blockstate = helmetEntity.getBlockState();
        float f1 = 22.5f * (float)((Integer)blockstate.getValue((Property)SkullBlock.ROTATION)).intValue();
        HelmetEntityRenderer.renderHelmet(null, f1, blockstate.getBlock(), 0.0f, PoseStack2, renderTypeBuffer, packedLight);
    }

    public static void renderHelmet(@Nullable Direction direction, float p_228879_1_, Block helmetBlock, float p_228879_4_, PoseStack PoseStack2, MultiBufferSource renderTypeBuffer, int p_228879_7_) {
        PoseStack2.pushPose();
        if (direction == null) {
            PoseStack2.translate(0.5, 0.0, 0.5);
        } else {
            PoseStack2.translate((double)(0.5f - (float)direction.getStepX() * 0.25f), 0.25, (double)(0.5f - (float)direction.getStepZ() * 0.25f));
        }
        PoseStack2.scale(-1.0f, -1.0f, 1.0f);
        VertexConsumer ivertexbuilder = renderTypeBuffer.getBuffer(HelmetEntityRenderer.getRenderType(helmetBlock));
        humanoidHeadModel.setupAnim(p_228879_4_, p_228879_1_, 0.0f);
        humanoidHeadModel.renderToBuffer(PoseStack2, ivertexbuilder, p_228879_7_, OverlayTexture.NO_OVERLAY);
        PoseStack2.popPose();
    }

    private static RenderType getRenderType(Block block) {
        ResourceLocation resourcelocation = TEXTURE_BY_TYPE.get(block);
        return RenderType.entityCutoutNoCullZOffset((ResourceLocation)resourcelocation);
    }
}

