/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.blocks;

import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonBeacon;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.registry.DSParticles;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.DragonBeaconBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class DragonBeaconRenderer
implements BlockEntityRenderer<DragonBeaconBlockEntity> {
    public DragonBeaconRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public void render(DragonBeaconBlockEntity beacon, float partialTick, PoseStack pose, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Item item;
        Level level = Objects.requireNonNull(beacon.getLevel());
        boolean hasMemoryBlock = level.getBlockState(beacon.getBlockPos().below()).is(DSBlocks.DRAGON_MEMORY_BLOCK);
        boolean isPaused = Minecraft.getInstance().isPaused();
        double x = (double)beacon.getBlockPos().getX() + (0.25 + (double)level.getRandom().nextInt(5) / 10.0);
        double y = (double)beacon.getBlockPos().getY() + 0.5;
        double z = (double)beacon.getBlockPos().getZ() + (0.25 + (double)level.getRandom().nextInt(5) / 10.0);
        boolean isActive = (Boolean)beacon.getBlockState().getValue((Property)BlockStateProperties.LIT);
        Item item2 = item = isActive ? (Item)DSItems.ACTIVATED_DRAGON_BEACON.value() : ((DragonBeacon)((Object)DSBlocks.DRAGON_BEACON.value())).asItem();
        if (!isPaused && isActive && beacon.tick % 5.0f == 0.0f && hasMemoryBlock) {
            double random = level.getRandom().nextDouble();
            ParticleOptions particle = random < 0.33 ? (ParticleOptions)DSParticles.CAVE_BEACON_PARTICLE.value() : (random < 0.66 ? (ParticleOptions)DSParticles.FOREST_BEACON_PARTICLE.value() : (ParticleOptions)DSParticles.SEA_BEACON_PARTICLE.value());
            level.addParticle(particle, x, y, z, 0.0, 0.0, 0.0);
        }
        if (!isPaused) {
            beacon.tick += 0.5f;
        }
        pose.pushPose();
        float bounce = Mth.sin((float)((beacon.tick + partialTick) / 20.0f + beacon.bobOffset)) * 0.1f + 0.1f;
        pose.translate(0.5, 0.25 + (double)(bounce / 2.0f), 0.5);
        pose.mulPose(Axis.YP.rotationDegrees(beacon.tick));
        pose.scale(2.0f, 2.0f, 2.0f);
        Minecraft.getInstance().getItemRenderer().renderStatic(item.getDefaultInstance(), ItemDisplayContext.GROUND, packedLight, packedOverlay, pose, buffer, level, 0);
        pose.popPose();
    }
}

