/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.FogType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class VisionHandler {
    private static boolean hadLavaVision;
    private static boolean hadWaterVision;

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        if (VisionHandler.hasLavaVision() && event.getCamera().getFluidInCamera() == FogType.LAVA) {
            event.setNearPlaneDistance(0.0f);
            event.setFarPlaneDistance(event.getRenderer().getRenderDistance() * 0.5f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void markChangedIfVisionStateChanged(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        boolean hasLavaVision = VisionHandler.hasLavaVision();
        boolean hasWaterVision = VisionHandler.hasWaterVision();
        boolean shouldUpdate = !hadLavaVision && hasLavaVision || hadLavaVision && !hasLavaVision;
        shouldUpdate = shouldUpdate || !hadWaterVision && hasWaterVision || hadWaterVision && !hasWaterVision;
        hadLavaVision = hasLavaVision;
        hadWaterVision = hasWaterVision;
        if (shouldUpdate) {
            event.getLevelRenderer().allChanged();
        }
    }

    public static boolean hasLavaVision() {
        Player player = DragonSurvival.PROXY.getLocalPlayer();
        if (player != null) {
            return player.hasEffect(DSEffects.LAVA_VISION);
        }
        return false;
    }

    public static boolean hasWaterVision() {
        Player player = DragonSurvival.PROXY.getLocalPlayer();
        if (player != null) {
            return player.hasEffect(DSEffects.WATER_VISION);
        }
        return false;
    }

    public static boolean hasVision(VisionType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> VisionHandler.hasWaterVision();
            case 1 -> VisionHandler.hasLavaVision();
        };
    }

    public static enum VisionType {
        WATER,
        LAVA;

    }
}

