/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render;

import by.dragonsurvivalteam.dragonsurvival.client.models.DragonModel;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.ActionContainer;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.compat.bettercombat.BetterCombat;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.input.Keybind;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.EntityRendererAccessor;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.LivingRendererAccessor;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncDeltaMovement;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncDragonMovement;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MovementData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.AbilityTargeting;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.AreaTarget;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.DiscTarget;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.DragonBreathTarget;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.LookingAtTarget;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderBlockScreenEffectEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.util.RenderUtil;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientDragonRenderer {
    public static DragonModel dragonModel = new DragonModel();
    private static final Map<Integer, DragonEntity> PLAYER_DRAGON_MAP = new ConcurrentHashMap<Integer, DragonEntity>();
    @Translation(key="render_dragon_in_first_person", type=Translation.Type.CONFIGURATION, comments={"If enabled the dragon body will be visible in first person"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="render_dragon_in_first_person")
    public static Boolean renderInFirstPerson = true;
    @Translation(key="render_first_person_flight", type=Translation.Type.CONFIGURATION, comments={"If enabled the dragon body will be visible in first person while flying"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="render_first_person_flight")
    public static Boolean renderFirstPersonFlight = false;
    @Translation(key="render_items_in_mouth", type=Translation.Type.CONFIGURATION, comments={"If enabled held items will be rendered neat the mouth of the dragon", "If disabled held items will be displayed on the side of the dragon"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="render_items_in_mouth")
    public static Boolean renderItemsInMouth = false;
    @Translation(key="render_held_item", type=Translation.Type.CONFIGURATION, comments={"If enabled items will be rendered for dragons while in third person mode"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="render_held_item")
    public static boolean renderHeldItem = true;
    @Translation(key="render_dragon_claws", type=Translation.Type.CONFIGURATION, comments={"If enabled dragon claws and teeth will have an overlay depending on the items in the claw slots"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="render_dragon_claws")
    public static Boolean renderDragonClaws = true;
    @Translation(key="render_custom_skin", type=Translation.Type.CONFIGURATION, comments={"If enabled your custom dragon skin will be rendered"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="render_custom_skin")
    public static Boolean renderCustomSkin = true;
    @Translation(key="render_other_players_custom_skins", type=Translation.Type.CONFIGURATION, comments={"If enabled custom skins of other players will be rendered"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="render_other_players_custom_skins")
    public static Boolean renderOtherPlayerSkins = true;
    @Translation(key="dragon_name_tags", type=Translation.Type.CONFIGURATION, comments={"If enabled name tags will be shown for dragons"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"rendering"}, key="dragon_name_tags")
    public static Boolean dragonNameTags = false;
    public static float partialTick = 1.0f;

    public static DragonEntity getOrCreateDragon(Player player) {
        return PLAYER_DRAGON_MAP.computeIfAbsent(player.getId(), key -> {
            DragonEntity newDragon = (DragonEntity)((EntityType)DSEntities.DRAGON.get()).create(player.level());
            newDragon.playerId = key;
            return newDragon;
        });
    }

    @Nullable
    public static DragonEntity getDragon(Player player) {
        return PLAYER_DRAGON_MAP.get(player.getId());
    }

    public static void process(Consumer<DragonEntity> processor) {
        PLAYER_DRAGON_MAP.values().forEach(processor);
    }

    @SubscribeEvent
    public static void removeEntry(EntityLeaveLevelEvent event) {
        Player player;
        DragonEntity dragon;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (dragon = PLAYER_DRAGON_MAP.remove((player = (Player)entity).getId())) != null) {
            DragonRenderer.BONE_POSITIONS.remove(dragon.getId());
        }
    }

    @SubscribeEvent
    public static void clearEntries(LevelEvent.Unload event) {
        PLAYER_DRAGON_MAP.clear();
        DragonRenderer.BONE_POSITIONS.clear();
    }

    @SubscribeEvent
    public static void renderAbilityHitbox(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS && Minecraft.getInstance().getEntityRenderDispatcher().shouldRenderHitBoxes()) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            if (!DragonStateProvider.isDragon((Entity)player)) {
                return;
            }
            MagicData magicData = MagicData.getData((Player)player);
            DragonAbilityInstance ability = magicData.fromSlot(magicData.getSelectedAbilitySlot());
            if (ability == null) {
                return;
            }
            VertexConsumer buffer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer((RenderType)RenderType.LINES);
            Vec3 camera = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            PoseStack pose = event.getPoseStack();
            pose.pushPose();
            pose.translate(-camera.x(), -camera.y(), -camera.z());
            for (ActionContainer action : ability.value().actions()) {
                AbilityTargeting targeting = action.effect();
                if (targeting instanceof DragonBreathTarget) {
                    DragonBreathTarget breathTarget = (DragonBreathTarget)targeting;
                    LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)buffer, (AABB)breathTarget.calculateBreathArea((Player)player, ability), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    continue;
                }
                if (targeting instanceof LookingAtTarget) {
                    HitResult result;
                    LookingAtTarget lookingAtTarget = (LookingAtTarget)targeting;
                    if (lookingAtTarget.target().left().isPresent()) {
                        result = lookingAtTarget.getBlockHitResult((Player)player, ability);
                    } else {
                        if (!lookingAtTarget.target().right().isPresent()) continue;
                        result = lookingAtTarget.getEntityHitResult((Player)player, entity -> true, ability);
                    }
                    if (result.getType() == HitResult.Type.BLOCK) {
                        BlockHitResult blockResult = (BlockHitResult)result;
                        LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)buffer, (AABB)new AABB(blockResult.getBlockPos()), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                        continue;
                    }
                    if (result.getType() != HitResult.Type.ENTITY) continue;
                    EntityHitResult entityResult = (EntityHitResult)result;
                    LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)buffer, (AABB)entityResult.getEntity().getBoundingBox().inflate(1.5), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    continue;
                }
                if (targeting instanceof AreaTarget) {
                    AreaTarget areaTarget = (AreaTarget)targeting;
                    LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)buffer, (AABB)areaTarget.calculateAffectedArea((Player)player, ability), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                    continue;
                }
                if (!(targeting instanceof DiscTarget)) continue;
                DiscTarget discTarget = (DiscTarget)targeting;
                int radius = (int)discTarget.radius().calculate(ability.level());
                int height = (int)discTarget.height().calculate(ability.level());
                LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)buffer, (AABB)discTarget.calculateAffectedArea(player.position(), radius, height), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            }
            pose.popPose();
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void cancelNameplatesFromDummyEntities(RenderNameTagEvent renderNameplateEvent) {
        Entity entity = renderNameplateEvent.getEntity();
        if (entity.getType() == DSEntities.DRAGON.get()) {
            renderNameplateEvent.setCanRender(TriState.FALSE);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void renderDragon(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (!(player instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player2 = (AbstractClientPlayer)player;
        DragonStateHandler handler = DragonStateProvider.getData((Player)player2);
        if (!handler.isDragon()) {
            return;
        }
        DragonEntity dragon = ClientDragonRenderer.getOrCreateDragon((Player)player2);
        dragon.renderingWasCancelled = event.isCanceled();
        if (event.isCanceled()) {
            return;
        }
        if (BetterCombat.isAttacking((Player)player2)) {
            ((PlayerModel)event.getRenderer().getModel()).setAllVisible(false);
        } else {
            event.setCanceled(true);
        }
        partialTick = event.getPartialTick();
        if (dragonNameTags.booleanValue() && player2 != Minecraft.getInstance().player) {
            RenderNameTagEvent renderNameplateEvent = new RenderNameTagEvent((Entity)player2, player2.getDisplayName(), (EntityRenderer)event.getRenderer(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), partialTick);
            NeoForge.EVENT_BUS.post((Event)renderNameplateEvent);
            if (renderNameplateEvent.canRender().isTrue() || renderNameplateEvent.canRender().isDefault() && ((LivingRendererAccessor)event.getRenderer()).dragonSurvival$callShouldShowName((LivingEntity)player2)) {
                ((EntityRendererAccessor)event.getRenderer()).dragonSurvival$renderNameTag((Entity)player2, renderNameplateEvent.getContent(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), partialTick);
            }
        }
        if (player2 != Minecraft.getInstance().player || !Minecraft.getInstance().options.getCameraType().isFirstPerson() || !ServerFlightHandler.isGliding((Player)player2) || renderFirstPersonFlight.booleanValue()) {
            if (!dragon.isInInventory) {
                ClientDragonRenderer.setDragonMovementData((Player)player2, Minecraft.getInstance().getTimer().getRealtimeDeltaTicks());
            }
            MovementData movement = MovementData.getData((Entity)player2);
            ClientDragonRenderer.handleFlightMovement((Player)player2, dragon, movement, partialTick);
            Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)dragon).render((Entity)dragon, player2.getViewYRot(partialTick), partialTick, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
        }
    }

    private static void handleFlightMovement(Player player, DragonEntity dragon, MovementData movement, float partialTick) {
        boolean isPlayerGliding = ServerFlightHandler.isGliding(player);
        Entity playerVehicle = player.getVehicle();
        if (isPlayerGliding || player.isPassenger() && DragonStateProvider.isDragon(playerVehicle) && ServerFlightHandler.isGliding((Player)playerVehicle)) {
            float targetRollNormalized;
            Vec3 deltaVel;
            float yRot;
            float upRot = isPlayerGliding ? Mth.clamp((float)((float)(player.getDeltaMovement().y * 20.0)), (float)-80.0f, (float)80.0f) : Mth.clamp((float)((float)(playerVehicle.getDeltaMovement().y * 20.0)), (float)-80.0f, (float)80.0f);
            dragon.prevXRot = Mth.lerp((float)0.1f, (float)dragon.prevXRot, (float)upRot);
            movement.prevXRot = dragon.prevXRot = Mth.clamp((float)dragon.prevXRot, (float)-80.0f, (float)80.0f);
            if (Float.isNaN(dragon.prevXRot)) {
                dragon.prevXRot = upRot;
            }
            if (Float.isNaN(dragon.prevXRot)) {
                dragon.prevXRot = 0.0f;
            }
            if (isPlayerGliding) {
                yRot = player.getViewYRot(partialTick);
                deltaVel = player.getDeltaMovement();
            } else {
                yRot = playerVehicle.getViewYRot(partialTick);
                deltaVel = playerVehicle.getDeltaMovement();
            }
            float ROLL_VEL_LERP_FACTOR = 0.1f;
            double ROLL_VEL_INFLUENCE_MIN = 0.5;
            double ROLL_VEL_INFLUENCE_MAX = 2.0;
            float ROLL_MIN_DELTA_DEG = 5.0f;
            float ROLL_MAX_DELTA_DEG = 90.0f;
            float ROLL_MAX_DEG = 60.0f;
            double ROLL_EXP = 0.7;
            if (deltaVel.horizontalDistanceSqr() > 0.25) {
                float velAngle = (float)Math.atan2(-deltaVel.x, deltaVel.z) * 57.295776f;
                float viewToVelDeltaDeg = Mth.degreesDifference((float)velAngle, (float)yRot);
                targetRollNormalized = (float)Functions.deadzoneNormalized(viewToVelDeltaDeg, 5.0, 90.0);
                targetRollNormalized = Math.copySign((float)Math.pow(Math.abs(targetRollNormalized), 0.7), targetRollNormalized);
                float velInfluence = (float)Functions.inverseLerpClamped(deltaVel.horizontalDistance(), 0.5, 2.0);
                targetRollNormalized *= velInfluence;
            } else {
                targetRollNormalized = 0.0f;
            }
            float targetRollDeg = targetRollNormalized * 60.0f * ((float)Math.PI / 180);
            dragon.prevZRot = !Double.isFinite(dragon.prevZRot) ? targetRollDeg : Mth.lerp((float)0.1f, (float)dragon.prevZRot, (float)targetRollDeg);
            movement.prevXRot = dragon.prevXRot;
            movement.prevZRot = dragon.prevZRot;
        } else {
            movement.prevZRot = 0.0f;
            movement.prevXRot = 0.0f;
        }
    }

    public static Vec3 getModelOffset(DragonEntity dragon, float partialTicks) {
        Player player = dragon.getPlayer();
        if (player == null) {
            return Vec3.ZERO;
        }
        float angle = -((float)MovementData.getData((Entity)player).bodyYaw) * ((float)Math.PI / 180);
        float x = Mth.sin((float)angle);
        float z = Mth.cos((float)angle);
        DragonStateHandler handler = DragonStateProvider.getData(player);
        float scale = (float)handler.getVisualScale(player, partialTicks) * (float)((DragonBody)handler.body().value()).scalingProportions().scaleMultiplier();
        return new Vec3((double)(x * scale), 0.0, (double)(z * scale));
    }

    public static Vector3f getModelShadowOffset(Player player, float partialRenderTick) {
        float angle = -((float)MovementData.getData((Entity)player).bodyYaw) * ((float)Math.PI / 180);
        float x = Mth.sin((float)angle);
        float z = Mth.cos((float)angle);
        DragonStateHandler handler = DragonStateProvider.getData(player);
        float scale = (float)handler.getVisualScale(player, partialRenderTick) * (float)((DragonBody)handler.body().value()).scalingProportions().shadowMultiplier();
        return new Vector3f(x * scale, 0.0f, z * scale);
    }

    @SubscribeEvent
    public static void spin(InputEvent.InteractionKeyMappingTriggered keyInputEvent) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!DragonStateProvider.isDragon((Entity)player)) {
            return;
        }
        MovementData movement = MovementData.getData((Entity)player);
        if (keyInputEvent.isAttack() && keyInputEvent.shouldSwingHand() && !movement.dig) {
            movement.bite = true;
        }
    }

    public static void setDragonMovementData(Player player, float realtimeDeltaTick) {
        if (player == null) {
            return;
        }
        if (DragonStateProvider.isDragon((Entity)player)) {
            MovementData movement = MovementData.getData((Entity)player);
            Vec3 moveVector = !ServerFlightHandler.isFlying(player) ? player.getDeltaMovement() : new Vec3(player.getX() - player.xo, player.getY() - player.yo, player.getZ() - player.zo);
            BodyAngles newAngles = BodyAngles.calculateNext(player, movement, realtimeDeltaTick);
            movement.set(newAngles.bodyYaw, newAngles.headYaw, newAngles.headPitch, moveVector);
        }
    }

    @SubscribeEvent
    public static void updateFirstPersonDataAndSendMovementData(ClientTickEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!DragonStateProvider.isDragon((Entity)player)) {
            return;
        }
        Input input = player.input;
        MovementData movement = MovementData.getData((Entity)player);
        movement.setFirstPerson(Minecraft.getInstance().options.getCameraType().isFirstPerson());
        movement.setFreeLook(Keybind.FREE_LOOK.consumeClick());
        float vertical = input.jumping && input.shiftKeyDown ? 0.0f : (input.jumping ? 1.0f : (input.shiftKeyDown ? -1.0f : 0.0f));
        movement.setDesiredMoveVec(new Vec3((double)input.leftImpulse, (double)vertical, (double)input.forwardImpulse));
        if (player.isPassenger()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncDeltaMovement(player.getId(), Vec3.ZERO), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncDeltaMovement(player.getId(), player.getDeltaMovement()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncDragonMovement(player.getId(), movement.isFirstPerson, movement.bite, movement.isFreeLook, movement.desiredMoveVec), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void removeFireOverlay(RenderBlockScreenEffectEvent event) {
        if (event.getOverlayType() != RenderBlockScreenEffectEvent.OverlayType.FIRE) {
            return;
        }
        Minecraft.getInstance().player.getExistingData(DSDataAttachments.DAMAGE_MODIFICATIONS).ifPresent(data -> {
            if (data.isFireImmune()) {
                event.setCanceled(true);
            }
        });
    }

    private record BodyAngles(double bodyYaw, double headPitch, double headYaw) {
        static final double MOVE_DELTA_EPSILON = 1.0E-4;
        static final double MOVE_DELTA_FULL_EFFECT_MIN_MAG = 0.3;
        static final double MOVE_ALIGN_FACTOR = 0.3;
        static final double MOVE_ALIGN_FACTOR_AIR = 0.12;
        static final double MOVE_ALIGN_FACTOR_AIR_PASSIVE_MUL = 0.75;
        static final double BODY_ANGLE_LIMIT_TP = 150.0;
        static final double BODY_ANGLE_LIMIT_TP_SOFTNESS = 0.9;
        static final double BODY_ANGLE_LIMIT_TP_SOFTNESS_AIR_MUL = 0.15;
        static final double BODY_ANGLE_LIMIT_TP_FREE = 180.0;
        static final double BODY_ANGLE_LIMIT_TP_SOFTNESS_FREE = 0.0;
        static final double BODY_ANGLE_LIMIT_TP_SOFTNESS_AIR_MUL_FREE = 0.0;
        static final double BODY_ANGLE_LIMIT_FP = 10.0;
        static final double BODY_ANGLE_LIMIT_FP_SOFTNESS = 0.75;
        static final double BODY_ANGLE_LIMIT_FP_SOFTNESS_AIR_MUL = 0.4;
        static final double BODY_ANGLE_LIMIT_FP_FREE = 60.0;
        static final double BODY_ANGLE_LIMIT_FP_FREE_SOFTNESS = 0.85;
        static final double BODY_ANGLE_LIMIT_FP_FREE_SOFTNESS_AIR_MUL = 0.4;
        static final double HEAD_YAW_FACTOR = 0.3;
        static final double HEAD_PITCH_FACTOR = 0.3;

        public static BodyAngles calculateNext(Player player, MovementData movement, float realtimeDeltaTick) {
            float viewYRot = player.getViewYRot(realtimeDeltaTick);
            float viewXRot = player.getViewXRot(realtimeDeltaTick);
            Vec3 posDelta = new Vec3(player.getX() - player.xo, player.getY() - player.yo, player.getZ() - player.zo);
            Tuple<Double, Double> headAngles = BodyAngles.calculateNextHeadAngles(realtimeDeltaTick, movement, viewXRot, viewYRot);
            return new BodyAngles(BodyAngles.calculateNextBodyYaw(realtimeDeltaTick, player, movement, posDelta, viewYRot), (Double)headAngles.getA(), (Double)headAngles.getB());
        }

        private static double calculateNextBodyYaw(float realtimeDeltaTick, Player player, MovementData movement, Vec3 posDelta, float viewYRot) {
            double airMul;
            double factor;
            double angleLimit;
            boolean isInputBack;
            double bodyYaw = movement.bodyYaw;
            boolean isFreeLook = movement.isFreeLook;
            boolean isFirstPerson = movement.isFirstPerson;
            boolean hasPosDelta = posDelta.horizontalDistanceSqr() > 1.0E-8;
            Vec3 rawInput = movement.desiredMoveVec;
            Vec2 horizontalMovement = new Vec2((float)rawInput.x, (float)rawInput.z);
            boolean hasMoveInput = (double)horizontalMovement.lengthSquared() > 9.999999999999998E-15;
            boolean bl = isInputBack = horizontalMovement.y < 0.0f;
            if (hasMoveInput) {
                double factor2;
                boolean isFlying;
                double targetAngle = Math.toDegrees(Math.atan2(-horizontalMovement.x, horizontalMovement.y)) + (double)viewYRot;
                boolean bl2 = isFlying = ServerFlightHandler.isFlying(player) || player.getAbilities().flying;
                if (isFirstPerson && !isFreeLook && isInputBack && !isFlying) {
                    targetAngle += 180.0;
                }
                double d = factor2 = player.onGround() ? 0.3 : 0.12;
                bodyYaw = isFirstPerson ? Functions.lerpAngleAwayFrom((double)realtimeDeltaTick * factor2, bodyYaw, targetAngle, viewYRot + 180.0f) : RenderUtil.lerpYaw((double)((double)realtimeDeltaTick * factor2), (double)bodyYaw, (double)targetAngle);
            } else if (hasPosDelta && !player.onGround()) {
                double posDeltaAngle = Math.toDegrees(Math.atan2(-posDelta.x, posDelta.z));
                double factor3 = 0.09;
                double deltaMagFactor = Math.min(1.0, (posDelta.horizontalDistance() - 1.0E-4) / 0.3);
                bodyYaw = RenderUtil.lerpYaw((double)((double)realtimeDeltaTick * (factor3 *= deltaMagFactor)), (double)bodyYaw, (double)posDeltaAngle);
            }
            if (isFirstPerson) {
                if (isFreeLook) {
                    angleLimit = 60.0;
                    factor = 0.85;
                    airMul = 0.4;
                } else {
                    angleLimit = 10.0;
                    factor = 0.75;
                    airMul = 0.4;
                }
            } else if (isFreeLook) {
                angleLimit = 180.0;
                factor = 0.0;
                airMul = 0.0;
            } else {
                angleLimit = 150.0;
                factor = 0.9;
                airMul = 0.15;
            }
            if (!player.onGround()) {
                factor *= airMul;
            }
            return Functions.limitAngleDeltaSoft(bodyYaw, viewYRot, angleLimit, (double)realtimeDeltaTick * factor);
        }

        private static Tuple<Double, Double> calculateNextHeadAngles(float realtimeDeltaTick, MovementData movement, float viewXRot, float viewYRot) {
            double headYawTarget = Functions.angleDifference((double)viewYRot, movement.bodyYaw);
            double headYaw = Functions.lerpAngleAwayFrom((double)realtimeDeltaTick * 0.3, movement.headYaw, headYawTarget, 180.0);
            double headPitch = Mth.lerp((double)((double)realtimeDeltaTick * 0.3), (double)movement.headPitch, (double)viewXRot);
            return new Tuple((Object)headPitch, (Object)headYaw);
        }
    }
}

