/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.particles;

import by.dragonsurvivalteam.dragonsurvival.common.particles.TreasureParticleOption;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class TreasureParticle
extends TextureSheetParticle {
    public TreasureParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, TreasureParticleOption data, SpriteSet spriteSet) {
        super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        this.rCol = data.red();
        this.gCol = data.green();
        this.bCol = data.blue();
        this.quadSize *= 0.75f * data.scale();
        int i = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.lifetime = (int)Math.max((float)i * data.scale(), 1.0f);
        this.pickSprite(spriteSet);
    }

    public float getQuadSize(float p_217561_1_) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + p_217561_1_) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    protected int getLightColor(float partialTick) {
        int color = super.getLightColor(partialTick);
        int red = FastColor.ARGB32.red((int)color);
        return 0xF0 | red << 16;
    }

    public static class Factory
    implements ParticleProvider<TreasureParticleOption> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(@NotNull TreasureParticleOption type, @NotNull ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new TreasureParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, type, this.sprites);
        }
    }
}

