/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.handlers;

import by.dragonsurvivalteam.dragonsurvival.client.util.FakeClientPlayerUtils;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class SmithingScreenHandler {
    public static int FAKE_PLAYER = 1;

    @SubscribeEvent
    public static void clearArmor(ScreenEvent.Closing event) {
        DragonStateHandler handler;
        if (event.getScreen() instanceof SmithingScreen && (handler = DragonStateProvider.getData((Player)Minecraft.getInstance().player)).isDragon()) {
            SmithingScreenHandler.clearEquipment((Player)FakeClientPlayerUtils.getFakePlayer(FAKE_PLAYER, handler));
        }
    }

    public static void copyEquipment(Player source, Player target) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            target.setItemSlot(slot, source.getItemBySlot(slot).copy());
        }
    }

    private static void clearEquipment(Player player) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            player.setItemSlot(slot, ItemStack.EMPTY);
        }
    }
}

