/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components;

import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.ScrollableComponent;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.ScreenAccessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public class BarComponent
implements ScrollableComponent {
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
    private final HoverButton leftArrow;
    private final HoverButton rightArrow;
    private final int displayAmount;
    private final int spacing;
    private final int xPos;
    private final int yPos;
    private int scrollAmount;

    public BarComponent(Screen screen, int xPos, int yPos, int displayAmount, List<? extends AbstractWidget> widgets, int spacing, int arrowLeftX, int arrowRightX, int arrowY, int arrowWidth, int arrowHeight, ResourceLocation leftArrowHover, ResourceLocation leftArrowMain, ResourceLocation rightArrowHover, ResourceLocation rightArrowMain) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.displayAmount = displayAmount;
        this.spacing = spacing;
        this.widgets.addAll(widgets);
        for (AbstractWidget abstractWidget : widgets) {
            ((ScreenAccessor)screen).dragonSurvival$addRenderableWidget(abstractWidget);
        }
        this.leftArrow = new HoverButton(xPos + arrowLeftX, yPos + arrowY, arrowWidth, arrowHeight, arrowWidth, arrowHeight, leftArrowMain, leftArrowHover, button -> this.scroll(false));
        this.rightArrow = new HoverButton(xPos + arrowRightX, yPos + arrowY, arrowWidth, arrowHeight, arrowWidth, arrowHeight, rightArrowMain, rightArrowHover, button -> this.scroll(true));
        ((ScreenAccessor)screen).dragonSurvival$addRenderableWidget(this.leftArrow);
        ((ScreenAccessor)screen).dragonSurvival$addRenderableWidget(this.rightArrow);
        this.leftArrow.visible = false;
        this.rightArrow.visible = widgets.size() > displayAmount;
        this.forceSetButtonPositions();
    }

    private boolean isHoveringOverWidget(double mouseX, double mouseY) {
        for (AbstractWidget widget : this.widgets) {
            if (!widget.isMouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void scroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (Screen.hasShiftDown() || !this.isHoveringOverWidget(mouseX, mouseY)) {
            return;
        }
        this.scroll(scrollY < 0.0);
    }

    private void scroll(boolean isNext) {
        if (this.widgets.size() <= this.displayAmount) {
            return;
        }
        if (isNext && this.displayAmount + this.scrollAmount < this.widgets.size()) {
            ++this.scrollAmount;
            if (this.leftArrow != null) {
                this.leftArrow.visible = true;
            }
            if (this.rightArrow != null && this.displayAmount + this.scrollAmount == this.widgets.size()) {
                this.rightArrow.visible = false;
            }
        } else if (!isNext && this.scrollAmount > 0) {
            --this.scrollAmount;
            if (this.rightArrow != null) {
                this.rightArrow.visible = true;
            }
            if (this.leftArrow != null && this.scrollAmount == 0) {
                this.leftArrow.visible = false;
            }
        }
        this.forceSetButtonPositions();
    }

    private boolean isVisibleElement(int index) {
        return index >= this.scrollAmount && index < this.displayAmount + this.scrollAmount;
    }

    private void forceSetButtonPositions() {
        for (int index = 0; index < this.widgets.size(); ++index) {
            AbstractWidget widget = this.widgets.get(index);
            widget.visible = this.isVisibleElement(index);
            if (!widget.visible) continue;
            if (this.widgets.size() < this.displayAmount) {
                int elementWidth = widget.getWidth() + this.spacing;
                int totalWidth = this.widgets.size() * elementWidth;
                int centeredX = this.xPos + (this.displayAmount * elementWidth - totalWidth) / 2;
                widget.setX(centeredX + index * elementWidth + this.spacing / 2);
            } else {
                widget.setX(this.xPos + (index - this.scrollAmount) * (widget.getWidth() + this.spacing));
            }
            widget.setY(this.yPos);
        }
    }

    public boolean isHidden(AbstractWidget widget) {
        if (widget == this.leftArrow && this.scrollAmount == 0) {
            return true;
        }
        if (widget == this.rightArrow && (this.widgets.size() < this.displayAmount || this.displayAmount + this.scrollAmount == this.widgets.size())) {
            return true;
        }
        int index = this.widgets.indexOf(widget);
        if (index == -1) {
            return false;
        }
        return !this.isVisibleElement(index);
    }
}

