/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components;

import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonAbilityScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.AbilityButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.ScrollableComponent;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.ScreenAccessor;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class AbilityColumnsComponent
implements ScrollableComponent {
    private static final int ELEMENTS_PER_COLUMN = 4;
    private static final int NUM_COLUMN_PHASES = 4;
    private static final int LEFT_SIDE = 0;
    private static final int MIDDLE = 1;
    private static final int RIGHT_SIDE = 2;
    private static final int BEHIND = 3;
    private final ArrayList<ArrayList<AbilityButton>> columns = new ArrayList();
    private final Vec3[][] buttonPositions = new Vec3[4][4];
    private final ButtonTemplateState[] buttonTemplateStates = new ButtonTemplateState[4];
    private final float TRANSITION_BACK_VISUAL_CUTOFF = 0.7f;
    private int currentColumn = 0;
    private int nextColumn = 0;

    public AbilityColumnsComponent(DragonAbilityScreen parentScreen, int xPos, int yPos, int verticalSpacing, int sideColumnSpacing, float sideColumnScale, float sideColumnOpacity, List<DragonAbilityInstance> abilities) {
        int i;
        for (i = 0; i < abilities.size(); ++i) {
            int column = i / 4;
            int row = i % 4;
            int y = yPos + row * verticalSpacing;
            if (this.columns.size() <= column) {
                this.columns.add(new ArrayList());
            }
            this.columns.get(column).add(((ScreenAccessor)((Object)parentScreen)).dragonSurvival$addRenderableWidget(new AbilityButton(xPos, y, abilities.get(i), parentScreen, sideColumnScale)));
        }
        for (i = 0; i < 4; ++i) {
            int xPosNew = i == 0 ? xPos - sideColumnSpacing : (i == 1 ? xPos : (i == 2 ? xPos + sideColumnSpacing : xPos));
            int zPosDefault = i == 1 ? 0 : -100;
            for (int j = 0; j < 4; ++j) {
                this.buttonPositions[i][j] = new Vec3((double)(xPos - xPosNew), 0.0, (double)zPosDefault);
            }
            float scale = i == 1 ? 1.0f : (i == 3 ? sideColumnScale / 2.0f : sideColumnScale);
            float alpha = i == 1 ? 1.0f : sideColumnOpacity;
            boolean isInteractable = i == 1;
            boolean isVisible = i != 3;
            this.buttonTemplateStates[i] = new ButtonTemplateState(scale, alpha, isInteractable, isVisible);
        }
        this.forceSetButtonPositions();
    }

    @Override
    public void update() {
        if (this.currentColumn == this.nextColumn) {
            return;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            for (int j = 0; j < this.columns.get(i).size(); ++j) {
                AbilityButton button = this.columns.get(i).get(j);
                int nextColumnPhase = this.convertIndexToColumnPhase(i, this.nextColumn);
                Vec3 currentOffset = button.getOffset();
                Vec3 nextOffset = this.buttonPositions[nextColumnPhase][j];
                float deltaTick = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks();
                float lerpRate = Math.min(1.0f, deltaTick);
                Vec3 newOffset = new Vec3(Mth.lerp((double)lerpRate, (double)currentOffset.x(), (double)nextOffset.x()), Mth.lerp((double)lerpRate, (double)currentOffset.y(), (double)nextOffset.y()), Mth.lerp((double)lerpRate, (double)currentOffset.z(), (double)nextOffset.z()));
                button.setOffset(newOffset);
                int currentColumnPhase = this.convertIndexToColumnPhase(i, this.currentColumn);
                float lerpProgress = (float)(1.0 - Math.abs((nextOffset.x() - currentOffset.x()) / (nextOffset.x() - this.buttonPositions[currentColumnPhase][j].x())));
                if (lerpProgress > 0.7f && nextColumnPhase == 3) {
                    button.setVisible(false);
                }
                ButtonTemplateState nextButtonTemplateState = this.buttonTemplateStates[nextColumnPhase];
                float currentScale = button.getScale();
                button.setScale(Mth.lerp((float)lerpRate, (float)currentScale, (float)nextButtonTemplateState.scale));
                float currentAlpha = button.getAlpha();
                button.setAlpha(Mth.lerp((float)lerpRate, (float)currentAlpha, (float)nextButtonTemplateState.alpha));
            }
        }
        if (Math.abs(this.buttonPositions[1][0].x() - this.columns.get(this.nextColumn).getFirst().getOffset().x()) < 0.1) {
            this.currentColumn = this.nextColumn;
            this.forceSetButtonPositions();
        }
    }

    @Override
    public void scroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.isHoveringOverButton(mouseX, mouseY) || Screen.hasShiftDown()) {
            return;
        }
        if (scrollY > 0.0) {
            this.rotateRight();
        } else if (scrollY < 0.0) {
            this.rotateLeft();
        }
    }

    private void forceSetButtonPositions() {
        for (int i = 0; i < this.columns.size(); ++i) {
            for (int j = 0; j < this.columns.get(i).size(); ++j) {
                int columnPhase = this.convertIndexToColumnPhase(i, this.currentColumn);
                AbilityButton button = this.columns.get(i).get(j);
                ButtonTemplateState buttonTemplateState = this.buttonTemplateStates[columnPhase];
                button.setOffset(this.buttonPositions[columnPhase][j]);
                button.setScale(buttonTemplateState.scale);
                button.setAlpha(buttonTemplateState.alpha);
                button.setInteractable(buttonTemplateState.interactable);
                button.setVisible(buttonTemplateState.visible);
            }
        }
    }

    private void rotateRight() {
        if (this.nextColumn != this.currentColumn || this.columns.size() == 1) {
            return;
        }
        this.nextColumn = (this.nextColumn + 1) % this.columns.size();
        for (ArrayList<AbilityButton> column : this.columns) {
            for (AbilityButton abilityButton : column) {
                abilityButton.setInteractable(false);
                abilityButton.setVisible(true);
            }
        }
    }

    private void rotateLeft() {
        if (this.nextColumn != this.currentColumn || this.columns.size() == 1) {
            return;
        }
        this.nextColumn = (this.nextColumn - 1 + this.columns.size()) % this.columns.size();
        for (ArrayList<AbilityButton> column : this.columns) {
            for (AbilityButton abilityButton : column) {
                abilityButton.setInteractable(false);
                abilityButton.setVisible(true);
            }
        }
    }

    private boolean isHoveringOverButton(double mouseX, double mouseY) {
        for (ArrayList<AbilityButton> column : this.columns) {
            for (AbilityButton abilityButton : column) {
                if (!abilityButton.isMouseOver(mouseX, mouseY)) continue;
                return true;
            }
        }
        return false;
    }

    private int wrapInt(int value, int min, int max) {
        if (value < min) {
            return max + 1 + value;
        }
        if (value > max) {
            return min - 1 + value;
        }
        return value;
    }

    private int signedDistanceFromCenter(int index, int centerColumn) {
        int distance = index - centerColumn;
        int size = this.columns.size();
        if (distance > size / 2) {
            distance -= size;
        } else if (distance < -size / 2) {
            distance += size;
        }
        return distance;
    }

    private int convertIndexToColumnPhase(int index, int centerColumn) {
        int signedDistanceFromCenter = this.signedDistanceFromCenter(index, centerColumn);
        if (this.columns.size() == 1) {
            return 1;
        }
        int wrap = this.wrapInt(signedDistanceFromCenter + 1, 0, 4);
        return wrap < 0 || wrap >= 4 ? 3 : wrap;
    }

    private record ButtonTemplateState(float scale, float alpha, boolean interactable, boolean visible) {
    }
}

