/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic;

import by.dragonsurvivalteam.dragonsurvival.client.util.RenderingUtils;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class ColorPickerButton
extends ExtendedButton {
    public final Color defaultColor;
    public final Consumer<Color> colorConsumer;
    double selectorX;
    double selectorY;

    public ColorPickerButton(int xPos, int yPos, int width, int height, Color defaultColor, Consumer<Color> colorConsumer) {
        super(xPos, yPos, width, height, (Component)Component.empty(), button -> {});
        this.defaultColor = defaultColor;
        this.colorConsumer = colorConsumer;
        float[] hsb = Color.RGBtoHSB(defaultColor.getRed(), defaultColor.getGreen(), defaultColor.getBlue(), null);
        this.selectorX = hsb[0] * (float)width;
        this.selectorY = hsb[2] < 1.0f ? hsb[2] * ((float)height / 2.0f) : (float)height / 2.0f + (1.0f - hsb[1]) * ((float)height / 2.0f);
    }

    public void resetColor() {
        Color emptyColor = new Color(0, 0, 0, 0);
        this.colorConsumer.accept(emptyColor);
        float[] hsb = Color.RGBtoHSB(emptyColor.getRed(), emptyColor.getGreen(), emptyColor.getBlue(), null);
        this.selectorX = hsb[0] * (float)this.width;
        this.selectorY = hsb[2] < 1.0f ? hsb[2] * ((float)this.height / 2.0f) : (float)this.height / 2.0f + (1.0f - hsb[1]) * ((float)this.height / 2.0f);
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        RenderingUtils.renderColorSquare(guiGraphics, this.getX(), this.getY(), this.width, this.height);
        RenderingUtils.fill(guiGraphics, (double)this.getX() + this.selectorX - 2.0, (double)this.getY() + this.selectorY - 2.0, (double)this.getX() + this.selectorX + 2.0, (double)this.getY() + this.selectorY + 2.0, Color.black.getRGB());
        RenderingUtils.fill(guiGraphics, (double)this.getX() + this.selectorX - 1.0, (double)this.getY() + this.selectorY - 1.0, (double)this.getX() + this.selectorX + 1.0, (double)this.getY() + this.selectorY + 1.0, this.getColor().getRGB());
    }

    public Color getColor() {
        double hue = this.selectorX / (double)this.width * 360.0 / 360.0;
        if (this.selectorY > (double)((float)this.height / 2.0f)) {
            double saturation = 1.0 - (this.selectorY - (double)((float)this.height / 2.0f)) / (double)((float)this.height / 2.0f) * 360.0 / 360.0;
            return Color.getHSBColor((float)hue, (float)saturation, 1.0f);
        }
        double brightness = this.selectorY / (double)((float)this.height / 2.0f) * 360.0 / 360.0;
        return Color.getHSBColor((float)hue, 1.0f, (float)brightness);
    }

    public void onClick(double pMouseX, double pMouseY) {
        this.selectorX = Mth.clamp((double)(pMouseX - (double)this.getX()), (double)0.0, (double)this.width);
        this.selectorY = Mth.clamp((double)(pMouseY - (double)this.getY()), (double)0.0, (double)this.height);
        this.colorConsumer.accept(this.getColor());
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.selectorX = Mth.clamp((double)(pMouseX - (double)this.getX()), (double)0.0, (double)this.width);
        this.selectorY = Mth.clamp((double)(pMouseY - (double)this.getY()), (double)0.0, (double)this.height);
        this.colorConsumer.accept(this.getColor());
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void playDownSound(@NotNull SoundManager handler) {
    }
}

