/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons;

import by.dragonsurvivalteam.dragonsurvival.magic.AbilityAndPenaltyTooltipRenderer;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class PenaltyButton
extends ExtendedButton {
    private static final int SIZE = 35;
    private final Holder<DragonPenalty> penalty;

    public PenaltyButton(int xPos, int yPos, Holder<DragonPenalty> penalty) {
        super(xPos, yPos, 35, 35, (Component)Component.empty(), action -> {});
        this.penalty = penalty;
        if (((DragonPenalty)penalty.value()).icon().isEmpty()) {
            Functions.logOrThrow("Penalties with no icon should not be added as button - [" + String.valueOf(penalty.getKey().location()) + "] is invalid");
        }
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation icon = ((DragonPenalty)this.penalty.value()).icon().orElse(MissingTextureAtlasSprite.getLocation());
        this.blit(graphics, icon, this.getX(), this.getY(), 35);
        if (this.isHovered()) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 250.0f);
            AbilityAndPenaltyTooltipRenderer.drawPenaltyTooltip(graphics, mouseX, mouseY, this.penalty);
            graphics.pose().popPose();
        }
    }

    private void blit(GuiGraphics graphics, ResourceLocation texture, int x, int y, int size) {
        graphics.blit(x, y, 0, size, size, Minecraft.getInstance().getGuiSprites().getSprite(texture), 1.0f, 1.0f, 1.0f, this.alpha);
    }
}

