/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets;

import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HelpButton;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.DragonAbilityHolder;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.data_components.DSDataComponents;
import by.dragonsurvivalteam.dragonsurvival.registry.data_maps.DietEntryCache;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2ic;

@EventBusSubscriber(value={Dist.CLIENT})
public class ToolTipHandler {
    @Translation(key="tooltip_changes", type=Translation.Type.CONFIGURATION, comments={"If enabled certain modifications to some tooltips will be made (e.g. dragon food items)"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"tooltips"}, key="tooltip_changes")
    public static Boolean TOOLTIP_CHANGES = true;
    @Translation(key="enchantment_descriptions", type=Translation.Type.CONFIGURATION, comments={"Adds enchantment descriptions to enchanted books which contain 1 enchantment (and said enchantment is from this mod)"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"tooltips"}, key="enchantment_descriptions")
    public static Boolean ENCHANTMENT_DESCRIPTIONS = true;
    @Translation(key="food_tooltip_style", type=Translation.Type.CONFIGURATION, comments={"Determines how dragon food tooltip is handled", "none: no food tooltip / default: always show current and others when shift is pressed / only_current: never show others / all_shift: show current and others only when shift is pressed"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"tooltips"}, key="food_tooltip_style")
    public static TooltipStyle TOOLTIP_STYLE = TooltipStyle.DEFAULT;
    @Translation(comments={"\u25a0 %s food: %s"})
    private static final String DRAGON_FOOD = Translation.Type.GUI.wrap("tooltip.dragon_food");
    @Translation(comments={"\u00a77\u25a0 Adds the following abilities: %s"})
    private static final String ADDS_ABILITIES = Translation.Type.GUI.wrap("tooltip.adds_abilities");
    @Translation(comments={"\u00a77\u25a0 Removes the following abilities: %s"})
    private static final String REMOVES_ABILITIES = Translation.Type.GUI.wrap("tooltip.removes_abilities");
    @Translation(comments={"\u00a77\u25a0 Applicable to: %s"})
    private static final String APPLICABLE_TO = Translation.Type.GUI.wrap("tooltip.applicable_to");
    @Translation(comments={"Press 'SHIFT' for more info"})
    private static final String PRESS_SHIFT = Translation.Type.GUI.wrap("tooltip.shift");
    private static final ResourceLocation TOOLTIP_BLINKING = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/magic_tips_1.png");
    private static final ResourceLocation TOOLTIP = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/magic_tips_0.png");
    private static boolean isBlinking;
    private static int tick;

    @SubscribeEvent
    public static void addAbilityHolderInfo(ItemTooltipEvent event) {
        DragonAbilityHolder holder = (DragonAbilityHolder)event.getItemStack().get(DSDataComponents.DRAGON_ABILITIES);
        if (holder == null) {
            return;
        }
        if (Screen.hasShiftDown()) {
            event.getToolTip().add(Component.translatable((String)(holder.isRemoval() ? REMOVES_ABILITIES : ADDS_ABILITIES), (Object[])new Object[]{Functions.translateHolderSet(holder.abilities(), Translation.Type.ABILITY)}));
            if (holder.applicableSpecies().isPresent()) {
                event.getToolTip().add(Component.translatable((String)APPLICABLE_TO, (Object[])new Object[]{Functions.translateHolderSet(holder.applicableSpecies().get(), Translation.Type.DRAGON_SPECIES)}));
            }
        } else {
            event.getToolTip().add(Component.translatable((String)PRESS_SHIFT).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    @SubscribeEvent
    public static void addDragonFoodTooltip(ItemTooltipEvent event) {
        MutableComponent tooltip2;
        HolderLookup.Provider provider = event.getContext().registries();
        if (provider == null || TOOLTIP_STYLE == TooltipStyle.NONE) {
            return;
        }
        Item item = event.getItemStack().getItem();
        Holder<DragonSpecies> playerSpecies = TOOLTIP_STYLE != TooltipStyle.ALL_SHIFT && event.getEntity() != null ? DragonStateProvider.getData(event.getEntity()).species() : null;
        if (playerSpecies != null && (tooltip2 = ToolTipHandler.getTooltip(playerSpecies, item)) != null) {
            event.getToolTip().add(tooltip2);
        }
        if (TOOLTIP_STYLE == TooltipStyle.ONLY_CURRENT) {
            return;
        }
        ArrayList dragonFoodTooltips = new ArrayList();
        provider.lookupOrThrow(DragonSpecies.REGISTRY).listElements().forEach(species -> {
            if (playerSpecies != null && species.is(playerSpecies)) {
                return;
            }
            MutableComponent tooltip = ToolTipHandler.getTooltip((Holder<DragonSpecies>)species, item);
            if (tooltip != null) {
                dragonFoodTooltips.add(tooltip);
            }
        });
        if (dragonFoodTooltips.isEmpty()) {
            return;
        }
        if (Screen.hasShiftDown()) {
            dragonFoodTooltips.forEach(tooltip -> event.getToolTip().add(tooltip));
        } else {
            event.getToolTip().add(Component.translatable((String)PRESS_SHIFT).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    @Nullable
    private static MutableComponent getTooltip(Holder<DragonSpecies> species, Item item) {
        MutableComponent foodData = ToolTipHandler.getFoodTooltipData(species, item);
        if (foodData.getContents() != PlainTextContents.EMPTY) {
            MutableComponent speciesTranslation = Component.translatable((String)Translation.Type.DRAGON_SPECIES.wrap(species.getKey().location()));
            return Component.translatable((String)DRAGON_FOOD, (Object[])new Object[]{speciesTranslation.withStyle(foodData.getStyle()), foodData}).withStyle(foodData.getStyle());
        }
        return null;
    }

    public static MutableComponent getFoodTooltipData(Holder<DragonSpecies> species, Item item) {
        FoodProperties properties = DietEntryCache.getDiet(species, item);
        if (properties == null) {
            return Component.empty();
        }
        ResourceLocation font = ((DragonSpecies)species.value()).miscResources().foodTooltip().font();
        String nutritionIcon = ((DragonSpecies)species.value()).miscResources().foodTooltip().nutritionIcon();
        String saturationIcon = ((DragonSpecies)species.value()).miscResources().foodTooltip().saturationIcon();
        String nutrition = String.format("%.1f", Float.valueOf((float)properties.nutrition() / 2.0f));
        String saturation = String.format("%.1f", Float.valueOf(properties.saturation() / 2.0f));
        int color = ((DragonSpecies)species.value()).miscResources().foodTooltip().color().map(TextColor::getValue).orElse(((DragonSpecies)species.value()).miscResources().primaryColor().getValue());
        MutableComponent nutritionComponent = Component.literal((String)(nutrition + " ")).withStyle(Style.EMPTY.withColor(color));
        MutableComponent saturationComponent = Component.literal((String)(" / " + saturation + " ")).withStyle(Style.EMPTY.withColor(color));
        return nutritionComponent.append(ToolTipHandler.parseIcon(nutritionIcon, font)).append((Component)saturationComponent).append(ToolTipHandler.parseIcon(saturationIcon, font));
    }

    private static Component parseIcon(String icon, ResourceLocation font) {
        String actualIcon = icon.length() == 6 && icon.startsWith("\\u") ? new String(Character.toChars(Integer.parseInt(icon.substring(2), 16))) : icon;
        return Component.literal((String)actualIcon).withStyle(Style.EMPTY.withFont(font).withColor(ChatFormatting.WHITE));
    }

    @SubscribeEvent
    public static void addCustomItemDescriptions(ItemTooltipEvent event) {
        if (event.getEntity() != null && event.getEntity().level().isClientSide() && event.getItemStack() != ItemStack.EMPTY) {
            String translationKey;
            ResourceLocation location = event.getItemStack().getItemHolder().getKey().location();
            MutableComponent description = null;
            if (ENCHANTMENT_DESCRIPTIONS.booleanValue() && event.getItemStack().getItem() instanceof EnchantedBookItem) {
                Holder holder;
                ResourceKey resourceKey;
                ItemEnchantments enchantments = (ItemEnchantments)event.getItemStack().get(DataComponents.STORED_ENCHANTMENTS);
                if (enchantments != null && enchantments.size() == 1 && (resourceKey = (holder = (Holder)((Object2IntMap.Entry)enchantments.entrySet().iterator().next()).getKey()).getKey()).location().getNamespace().equals("dragonsurvival")) {
                    description = Component.translatable((String)Translation.Type.ENCHANTMENT_DESCRIPTION.wrap(resourceKey.location().getPath())).withStyle(ChatFormatting.DARK_GRAY);
                }
            } else if (location.getNamespace().equals("dragonsurvival") && I18n.exists((String)(translationKey = Translation.Type.DESCRIPTION_ADDITION.wrap(location.getPath())))) {
                description = Component.translatable((String)translationKey);
            }
            if (description != null) {
                event.getToolTip().add(description);
            }
        }
    }

    @SubscribeEvent
    public static void renderHelpTextCornerElements(RenderTooltipEvent.Pre event) {
        boolean render = ToolTipHandler.isHelpText();
        if (!render) {
            return;
        }
        if (!isBlinking) {
            if (tick >= Functions.secondsToTicks(30.0)) {
                isBlinking = true;
                tick = 0;
            }
        } else if (tick >= Functions.secondsToTicks(5.0)) {
            isBlinking = false;
            tick = 0;
        }
        ++tick;
        int width = 0;
        int height = event.getComponents().size() == 1 ? -2 : 0;
        for (ClientTooltipComponent component : event.getComponents()) {
            int componentWidth = component.getWidth(event.getFont());
            if (componentWidth > width) {
                width = componentWidth;
            }
            height += component.getHeight();
        }
        Vector2ic tooltipPosition = event.getTooltipPositioner().positionTooltip(event.getScreenWidth(), event.getScreenHeight(), event.getX(), event.getY(), width, height);
        int x = tooltipPosition.x();
        int y = tooltipPosition.y();
        int textureWidth = 128;
        int textureHeight = 128;
        event.getGraphics().blit(isBlinking ? TOOLTIP_BLINKING : TOOLTIP, x - 8 - 6, y - 8 - 6, 400, 1.0f, (float)(1 % textureHeight), 16, 16, textureWidth, textureHeight);
        event.getGraphics().blit(isBlinking ? TOOLTIP_BLINKING : TOOLTIP, x + width - 8 + 6, y - 8 - 6, 400, (float)(textureWidth - 16 - 1), (float)(1 % textureHeight), 16, 16, textureWidth, textureHeight);
        event.getGraphics().blit(isBlinking ? TOOLTIP_BLINKING : TOOLTIP, x - 8 - 6, y + height - 8 + 6, 400, 1.0f, (float)(1 % textureHeight + 16), 16, 16, textureWidth, textureHeight);
        event.getGraphics().blit(isBlinking ? TOOLTIP_BLINKING : TOOLTIP, x + width - 8 + 6, y + height - 8 + 6, 400, (float)(textureWidth - 16 - 1), (float)(1 % textureHeight + 16), 16, 16, textureWidth, textureHeight);
        event.getGraphics().blit(isBlinking ? TOOLTIP_BLINKING : TOOLTIP, x + width / 2 - 47, y - 16, 400, (float)(16 + 2 * textureWidth + 1), (float)(1 % textureHeight), 94, 16, textureWidth, textureHeight);
        event.getGraphics().blit(isBlinking ? TOOLTIP_BLINKING : TOOLTIP, x + width / 2 - 47, y + height, 400, (float)(16 + 2 * textureWidth + 1), (float)(1 % textureHeight + 16), 94, 16, textureWidth, textureHeight);
    }

    private static boolean isHelpText() {
        if (!TOOLTIP_CHANGES.booleanValue()) {
            return false;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null || minecraft.screen == null) {
            return false;
        }
        for (GuiEventListener element : minecraft.screen.children()) {
            HelpButton helpButton;
            if (!(element instanceof HelpButton) || !(helpButton = (HelpButton)element).isHovered()) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void renderTooltipBorderInDragonColor(RenderTooltipEvent.Color event) {
        if (!TOOLTIP_CHANGES.booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        DragonStateHandler data = DragonStateProvider.getData((Player)player);
        if (!data.isDragon()) {
            return;
        }
        if (ToolTipHandler.isHelpText()) {
            event.setBorderStart(DSColors.withAlpha(10126490, 1.0f));
            event.setBorderEnd(DSColors.withAlpha(0x594459, 1.0f));
        } else if (DietEntryCache.getDiet(data.species(), event.getItemStack().getItem()) != null) {
            event.setBorderStart(DSColors.toARGB(((DragonSpecies)data.species().value()).miscResources().primaryColor()));
            event.setBorderEnd(DSColors.toARGB(((DragonSpecies)data.species().value()).miscResources().secondaryColor()));
        }
    }

    public static enum TooltipStyle {
        NONE,
        DEFAULT,
        ONLY_CURRENT,
        ALL_SHIFT;

    }
}

