/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.GrowthItem;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;

public record TimeComponent(Item item, int ticks, BiFunction<Item, Integer, Component> description) implements TooltipComponent
{
    @Translation(comments={"%s %s"})
    private static final String TIME = Translation.Type.GUI.wrap("time_of");
    @Translation(comments={"Stops or starts natural growth"})
    private static final String SWITCHES_GROWTH = Translation.Type.GUI.wrap("switches_growth");
    public static final BiFunction<Item, Integer, Component> DEFAULT = (item, ticks) -> Component.translatable((String)item.getDescriptionId()).append(": ").append(TimeComponent.translateTime(ticks));
    public static final BiFunction<Item, Integer, Component> GROWTH = (item, ticks) -> {
        MutableComponent growthInfo;
        Player player = DragonSurvival.PROXY.getLocalPlayer();
        DragonStateHandler handler = DragonStateProvider.getData(player);
        GrowthItem growthItem = ((DragonStage)handler.stage().value()).growthItems().stream().filter(entry -> entry.items().contains((Holder)item.builtInRegistryHolder())).findFirst().get();
        Object object = growthInfo = ticks == 0 ? Component.translatable((String)SWITCHES_GROWTH) : TimeComponent.translateTime(ticks);
        if (growthItem.maximumUsages() == -1) {
            return Component.translatable((String)item.getDescriptionId()).append(": ").append((Component)growthInfo);
        }
        int numberOfUses = handler.getGrowthUses((Item)item);
        MutableComponent usage = Component.translatable((String)String.format(" (%s / %s)", growthItem.maximumUsages() - numberOfUses, growthItem.maximumUsages()));
        if (numberOfUses == growthItem.maximumUsages()) {
            usage = usage.withStyle(ChatFormatting.DARK_GRAY);
        }
        return Component.translatable((String)item.getDescriptionId()).append(": ").append((Component)growthInfo).append((Component)usage);
    };

    private static Component translateTime(int ticks) {
        return Component.translatable((String)TIME, (Object[])new Object[]{ticks > 0 ? "+" : "-", Functions.Time.fromTicks(ticks).format()}).withStyle(ticks > 0 ? ChatFormatting.GREEN : ChatFormatting.RED);
    }
}

