/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.DragonEditorScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons.DragonBodyButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.TabButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.BarComponent;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.render.entity.dragon.DragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.skins.DragonSkins;
import by.dragonsurvivalteam.dragonsurvival.client.skins.SkinObject;
import by.dragonsurvivalteam.dragonsurvival.client.util.FakeClientPlayerUtils;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.config.ConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import by.dragonsurvivalteam.dragonsurvival.network.dragon_editor.SyncDragonSkinSettings;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSDragonBodyTags;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.BuiltInDragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.datapacks.AncientDatapack;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStages;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import com.ibm.icu.impl.Pair;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class DragonSkinsScreen
extends Screen {
    @Translation(comments={"Skin Settings"})
    private static final String SETTINGS = Translation.Type.GUI.wrap("skin_screen.settings");
    @Translation(comments={"\u25a0 This is a link to our \u00a76Wiki\u00a7r dedicated to making your own skin!\u00a77 Remember that this will be very difficult, and requires knowledge of graphic editors. You can order a skin or a custom species from the author and thus support the project!"})
    private static final String WIKI = Translation.Type.GUI.wrap("skin_screen.wiki");
    @Translation(comments={"\u25a0 \u00a76Skin\u00a7r is a texture for your dragon. There are two types of skins: built-in and custom. ", "\u25a0 \u00a76Custom skin\u00a7r\u00a7f you can draw yourself and upload to our github so that all players can see this texture.", "\u00a77\u25a0 If you are interested in how to make your own skin or take a commission, use the buttons on the right."})
    private static final String HELP = Translation.Type.GUI.wrap("skin_screen.help");
    @Translation(comments={"\u25a0 Shows a randomly selected \u00a76other player\u00a7r\u00a7f who uploaded a skin.", "\u25a0\u00a77 You \u00a7ccan't use\u00a7r\u00a7f\u00a77 their skins for yourself! Only look and admire! >:D"})
    private static final String RANDOM_INFO = Translation.Type.GUI.wrap("skin_screen.random_info");
    @Translation(comments={"If you are using a \u00a76texture pack\u00a7r\u00a7f to test your custom skin before submitting it, check this box."})
    private static final String DEFAULT_SKIN_INFO = Translation.Type.GUI.wrap("dragon_editor.default_skin_info");
    @Translation(comments={"Show custom player skins"})
    private static final String SHOW_OTHER_CUSTOM_SKINS = Translation.Type.GUI.wrap("skin_screen.show_other_custom_skins");
    @Translation(comments={"Show your custom skin"})
    private static final String SHOW_CUSTOM_SKIN = Translation.Type.GUI.wrap("skin_screen.show_custom_skin");
    @Translation(comments={"Open Editor"})
    private static final String OPEN_EDITOR = Translation.Type.GUI.wrap("skin_screen.open_editor");
    @Translation(comments={"Your skin is not available"})
    private static final String CUSTOM_MODEL_WARNING_1 = Translation.Type.GUI.wrap("skin_screen.custom_model_warning");
    @Translation(comments={"because you are using a custom model."})
    private static final String CUSTOM_MODEL_WARNING_2 = Translation.Type.GUI.wrap("skin_screen.custom_model_warning_2");
    @Translation(comments={"No skin found for this stage"})
    private static final String NO_SKIN = Translation.Type.GUI.wrap("skin_screen.no_skin");
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/skin_interface.png");
    private static final ResourceLocation BUTTON_BACKGROUND_BLACK = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/background_black.png");
    private static final ResourceLocation BUTTON_BACKGROUND_WHITE = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/background_white.png");
    private static final ResourceLocation STAGE_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/stage_background.png");
    private static final ResourceLocation SKIN_ON = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/skin_on.png");
    private static final ResourceLocation SKIN_OFF = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/skin_off.png");
    private static final ResourceLocation RANDOM_SKIN_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/random_skin_main.png");
    private static final ResourceLocation RANDOM_SKIN_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/random_skin_hover.png");
    private static final ResourceLocation RESET_SKIN_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/reset_skin_hover.png");
    private static final ResourceLocation RESET_SKIN_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/reset_skin_main.png");
    private static final ResourceLocation STAGE_ARROW_LEFT_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/stage_arrow_left_main.png");
    private static final ResourceLocation STAGE_ARROW_LEFT_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/stage_arrow_left_hover.png");
    private static final ResourceLocation STAGE_ARROW_RIGHT_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/stage_arrow_right_main.png");
    private static final ResourceLocation STAGE_ARROW_RIGHT_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/stage_arrow_right_hover.png");
    private static final ResourceLocation BODY_ARROW_LEFT_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/body_arrow_left_main.png");
    private static final ResourceLocation BODY_ARROW_LEFT_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/body_arrow_left_hover.png");
    private static final ResourceLocation BODY_ARROW_RIGHT_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/body_arrow_right_main.png");
    private static final ResourceLocation BODY_ARROW_RIGHT_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/body_arrow_right_hover.png");
    private static final ResourceLocation OPEN_EDITOR_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/open_editor_main.png");
    private static final ResourceLocation OPEN_EDITOR_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/open_editor_hover.png");
    private static final ResourceLocation OLD_TEXTURE_ON = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/texturepack_on.png");
    private static final ResourceLocation OLD_TEXTURE_OFF = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/texturepack_off.png");
    private static final ResourceLocation INFO_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/info_hover.png");
    private static final ResourceLocation INFO_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/info_main.png");
    private static final ResourceLocation WIKI_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/wiki_main.png");
    private static final ResourceLocation WIKI_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/wiki_hover.png");
    private static final ResourceLocation DISCORD_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/discord_main.png");
    private static final ResourceLocation DISCORD_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/discord_hover.png");
    private static final ResourceLocation ADDITIONS_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/skin/additions_background.png");
    private static final ArrayList<String> SEEN_SKINS = new ArrayList();
    private static final String SKIN_WIKI_URL = "https://github.com/DragonSurvivalTeam/DragonSurvival/wiki/3.-Customization";
    private static Holder<DragonStage> dragonStage;
    private static ResourceLocation skinTexture;
    private static ResourceLocation glowTexture;
    private static String playerName;
    private static String lastPlayerName;
    private static boolean noSkin;
    private boolean showYourSkin;
    public final DragonStateHandler handler = new DragonStateHandler();
    private HoverButton playerNameDisplay;
    private HoverButton playerStageDisplay;
    private int guiLeft;
    private int guiTop;
    private float yRot = -3.0f;
    private float xRot = -5.0f;
    private float zoom;

    public DragonSkinsScreen() {
        super((Component)Component.empty());
        this.minecraft = Minecraft.getInstance();
        if (dragonStage == null) {
            dragonStage = DragonStage.get((HolderLookup.Provider)this.minecraft.player.registryAccess(), Double.MAX_VALUE);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        this.renderBlurredBackground(partialTick);
        int startX = this.guiLeft;
        int startY = this.guiTop;
        this.setTextures();
        DragonEntity dragon = FakeClientPlayerUtils.getFakeDragon(0, this.handler);
        EntityRenderer dragonRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)dragon);
        if (noSkin && Objects.equals(playerName, this.minecraft.player.getGameProfile().getName())) {
            ClientDragonRenderer.dragonModel.setOverrideTexture(null);
            ((DragonRenderer)dragonRenderer).glowTexture = null;
        } else {
            ClientDragonRenderer.dragonModel.setOverrideTexture(skinTexture);
            ((DragonRenderer)dragonRenderer).glowTexture = glowTexture;
        }
        float scale = this.zoom;
        if (!(dragonStage == null || DragonSkins.playerSkinOrGlowFetchingInProgress(playerName, (ResourceKey<DragonStage>)dragonStage.getKey()) || !this.showYourSkin && Objects.equals(playerName, this.minecraft.player.getGameProfile().getName()))) {
            if (!DragonSkins.fetchHasFailed(playerName, (ResourceKey<DragonStage>)dragonStage.getKey()) || Objects.equals(playerName, this.minecraft.player.getGameProfile().getName())) {
                if (this.handler.stage() == null) {
                    boolean alreadyUsingDefaults = this.handler.getCurrentSkinPreset().isStageUsingDefaultSkin((ResourceKey<DragonStage>)dragonStage.getKey());
                    this.handler.setGrowth(null, ((DragonSpecies)this.handler.species().value()).getStartingGrowth((HolderLookup.Provider)this.minecraft.player.registryAccess()));
                    this.updateHandlerToUseCorrectSkinData();
                    this.handler.getCurrentSkinPreset().setAllStagesToUseDefaultSkin(alreadyUsingDefaults);
                    dragonStage = this.handler.stage();
                }
                FakeClientPlayerUtils.getFakePlayer((int)0, (DragonStateHandler)this.handler).animationSupplier = () -> "fly_animation_magic";
                Quaternionf quaternion = Axis.ZP.rotationDegrees(180.0f);
                quaternion.mul((Quaternionfc)Axis.XP.rotationDegrees(this.yRot * 10.0f));
                quaternion.rotateY((float)Math.toRadians(180.0f - this.xRot * 10.0f));
                InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)(startX + 15), (float)(startY + 70), (float)((int)scale), (Vector3f)new Vector3f(0.0f, 0.0f, 100.0f), (Quaternionf)quaternion, null, (LivingEntity)dragon);
            } else {
                DragonSkinsScreen.drawNonShadowString(guiGraphics, this.minecraft.font, (Component)Component.translatable((String)NO_SKIN).withStyle(ChatFormatting.RED), startX + 21, startY + 40, -1);
            }
        } else if (!this.showYourSkin && Objects.equals(playerName, this.minecraft.player.getGameProfile().getName())) {
            DragonSkinsScreen.drawNonShadowString(guiGraphics, this.minecraft.font, (Component)Component.translatable((String)CUSTOM_MODEL_WARNING_1).withStyle(ChatFormatting.RED), startX + 26, startY + 40, -1);
            DragonSkinsScreen.drawNonShadowString(guiGraphics, this.minecraft.font, (Component)Component.translatable((String)CUSTOM_MODEL_WARNING_2).withStyle(ChatFormatting.RED), startX + 26, startY + 50, -1);
        }
        ((DragonRenderer)dragonRenderer).glowTexture = null;
        guiGraphics.blit(BACKGROUND_TEXTURE, startX + 128, startY, 0, 0, 164, 256);
        DragonSkinsScreen.drawNonShadowString(guiGraphics, this.minecraft.font, (Component)Component.translatable((String)SETTINGS).withStyle(ChatFormatting.BLACK), startX + 128 + 82, startY + 7, -1);
        this.playerNameDisplay.setMessage((Component)Component.literal((String)playerName));
        this.playerStageDisplay.setMessage(DragonStage.translatableName((ResourceKey<DragonStage>)dragonStage.getKey()));
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    public static void drawNonShadowString(@NotNull GuiGraphics guiGraphics, Font font, Component component, int x, int y, int color) {
        guiGraphics.drawString(font, Language.getInstance().getVisualOrder((FormattedText)component), x - font.width((FormattedText)component) / 2, y, color, false);
    }

    private void updateHandlerToUseCorrectSkinData() {
        DragonStateHandler playerData = DragonStateProvider.getData((Player)this.minecraft.player);
        ResourceKey<DragonSpecies> speciesToUseForSkinData = playerData.isDragon() && (playerData.species().is(BuiltInDragonSpecies.CAVE_DRAGON) || playerData.species().is(BuiltInDragonSpecies.FOREST_DRAGON) || playerData.species().is(BuiltInDragonSpecies.SEA_DRAGON)) ? playerData.speciesKey() : BuiltInDragonSpecies.CAVE_DRAGON;
        this.handler.setCurrentStageCustomization(DragonStateProvider.getData((Player)this.minecraft.player).getCustomizationForStageAndSpecies(speciesToUseForSkinData, (ResourceKey<DragonStage>)dragonStage.getKey()));
    }

    public void init() {
        super.init();
        if (ResourceHelper.all((HolderLookup.Provider)this.minecraft.player.registryAccess(), DragonBody.REGISTRY).stream().noneMatch(body -> ((DragonBody)body.value()).model().equals((Object)DragonBody.DEFAULT_MODEL))) {
            DragonSurvival.LOGGER.warn("No dragon body in the registry uses the default dragon model. Cannot use the Skins screen in this situation.");
            this.onClose();
            return;
        }
        Minecraft minecraft = this.getMinecraft();
        final LocalPlayer player = minecraft.player;
        this.guiLeft = (this.width - 256) / 2;
        this.guiTop = (this.height - 128) / 2;
        int startX = this.guiLeft;
        int startY = this.guiTop;
        if (playerName == null) {
            playerName = Objects.requireNonNull(player).getGameProfile().getName();
        }
        DragonStateHandler playerHandler = DragonStateProvider.getData((Player)minecraft.player);
        this.handler.deserializeNBT((HolderLookup.Provider)minecraft.player.registryAccess(), playerHandler.serializeNBT((HolderLookup.Provider)minecraft.player.registryAccess()));
        if (!DragonSpecies.isBuiltIn(this.handler.speciesKey())) {
            this.handler.setSpecies(null, (Holder<DragonSpecies>)player.registryAccess().holderOrThrow(BuiltInDragonSpecies.CAVE_DRAGON));
        }
        if (!((DragonBody)playerHandler.body().value()).model().equals((Object)DragonBody.DEFAULT_MODEL)) {
            this.showYourSkin = false;
            ResourceHelper.all(null, DragonBody.REGISTRY).stream().filter(body -> ((DragonBody)body.value()).model().equals((Object)DragonBody.DEFAULT_MODEL)).findFirst().ifPresent(body -> this.handler.setBody(null, (Holder<DragonBody>)body));
        } else {
            this.showYourSkin = true;
        }
        this.handler.setStage(null, dragonStage);
        this.updateHandlerToUseCorrectSkinData();
        this.handler.getCurrentSkinPreset().setAllStagesToUseDefaultSkin(playerHandler.getCurrentSkinPreset().isAnyStageUsingDefaultSkin());
        TabButton.addTabButtonsToScreen(this, startX + 138, startY - 26, TabButton.TabButtonType.SKINS_TAB);
        ArrayList<DragonBodyButton> dragonBodyWidgets = new ArrayList<DragonBodyButton>();
        for (Holder<DragonBody> dragonBodyHolder : DSDragonBodyTags.getOrdered(null)) {
            if (!((DragonBody)dragonBodyHolder.value()).model().equals((Object)DragonBody.DEFAULT_MODEL)) continue;
            dragonBodyWidgets.add(this.createButton(dragonBodyHolder, 0, 0));
        }
        new BarComponent(this, startX + 128 + 4, this.height / 2 + 14, 4, dragonBodyWidgets, 5, -15, 160, 7, 18, 20, BODY_ARROW_LEFT_HOVER, BODY_ARROW_LEFT_MAIN, BODY_ARROW_RIGHT_HOVER, BODY_ARROW_RIGHT_MAIN);
        this.playerNameDisplay = new HoverButton(startX - 62, startY - 50, 165, 22, 165, 22, BUTTON_BACKGROUND_WHITE, BUTTON_BACKGROUND_WHITE, button -> {});
        this.playerNameDisplay.setMessage((Component)Component.literal((String)Objects.requireNonNull(player).getGameProfile().getName()));
        this.addRenderableOnly((Renderable)this.playerNameDisplay);
        this.playerStageDisplay = new HoverButton(startX - 55, startY + 150, 149, 22, 149, 22, STAGE_BACKGROUND, STAGE_BACKGROUND, button -> {});
        this.playerStageDisplay.setMessage(DragonStage.translatableName((ResourceKey<DragonStage>)dragonStage.getKey()));
        this.addRenderableOnly((Renderable)this.playerStageDisplay);
        HoverButton leftArrowButton = new HoverButton(startX - 62, startY + 153, 9, 16, 18, 18, STAGE_ARROW_LEFT_MAIN, STAGE_ARROW_LEFT_HOVER, button -> {
            ResourceKey<DragonStage> nextLevel = dragonStage.getKey();
            if (dragonStage.is(AncientDatapack.ancient)) {
                nextLevel = DragonStages.adult;
            } else if (dragonStage.is(DragonStages.adult)) {
                nextLevel = DragonStages.young;
            } else if (dragonStage.is(DragonStages.young)) {
                nextLevel = DragonStages.newborn;
            } else if (dragonStage.is(DragonStages.newborn)) {
                nextLevel = DragonStages.adult;
            }
            boolean alreadyUsingDefaults = this.handler.getCurrentSkinPreset().isStageUsingDefaultSkin((ResourceKey<DragonStage>)dragonStage.getKey());
            dragonStage = Objects.requireNonNull(player).registryAccess().holderOrThrow(Objects.requireNonNull(nextLevel));
            this.handler.setStage(null, dragonStage);
            this.updateHandlerToUseCorrectSkinData();
            this.handler.getCurrentSkinPreset().setAllStagesToUseDefaultSkin(alreadyUsingDefaults);
        });
        this.addRenderableWidget((GuiEventListener)leftArrowButton);
        HoverButton rightArrowButton = new HoverButton(startX + 92, startY + 153, 9, 16, 18, 18, STAGE_ARROW_RIGHT_MAIN, STAGE_ARROW_RIGHT_HOVER, button -> {
            ResourceKey<DragonStage> nextLevel = dragonStage.getKey();
            boolean ancientDataPackExists = ResourceHelper.get((HolderLookup.Provider)Objects.requireNonNull(player).registryAccess(), AncientDatapack.ancient).isPresent();
            if (ancientDataPackExists && dragonStage.is(AncientDatapack.ancient)) {
                nextLevel = DragonStages.newborn;
            } else if (dragonStage.is(DragonStages.newborn)) {
                nextLevel = DragonStages.young;
            } else if (dragonStage.is(DragonStages.young)) {
                nextLevel = DragonStages.adult;
            } else if (dragonStage.is(DragonStages.adult)) {
                nextLevel = DragonStages.newborn;
            }
            boolean alreadyUsingDefaults = this.handler.getCurrentSkinPreset().isStageUsingDefaultSkin((ResourceKey<DragonStage>)dragonStage.getKey());
            dragonStage = Objects.requireNonNull(player).registryAccess().holderOrThrow(Objects.requireNonNull(nextLevel));
            this.handler.setStage(null, dragonStage);
            this.updateHandlerToUseCorrectSkinData();
            this.handler.getCurrentSkinPreset().setAllStagesToUseDefaultSkin(alreadyUsingDefaults);
        });
        this.addRenderableWidget((GuiEventListener)rightArrowButton);
        HoverButton toggleRenderingOwnSkin = new HoverButton(this, startX + 128, startY + 26, 165, 22, 165, 22, BUTTON_BACKGROUND_BLACK, BUTTON_BACKGROUND_BLACK, button -> {
            DragonStateHandler handler = DragonStateProvider.getData((Player)Objects.requireNonNull(player));
            handler.getSkinData().renderCustomSkin = !handler.getSkinData().renderCustomSkin;
            ConfigHandler.updateConfigValue("render_custom_skin", handler.getSkinData().renderCustomSkin);
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncDragonSkinSettings(player.getId(), handler.getSkinData().renderCustomSkin), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }){

            @Override
            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
                guiGraphics.blit(DragonStateProvider.getData((Player)((Player)Objects.requireNonNull(player))).getSkinData().renderCustomSkin ? SKIN_ON : SKIN_OFF, this.getX() + 3, this.getY() + 5, 0.0f, 0.0f, 14, 14, 14, 14);
            }
        };
        toggleRenderingOwnSkin.setMessage((Component)Component.translatable((String)SHOW_CUSTOM_SKIN));
        this.addRenderableWidget((GuiEventListener)toggleRenderingOwnSkin);
        HoverButton toggleRenderingOtherSkins = new HoverButton(this, startX + 128, startY + 26 + 26, 165, 22, 165, 22, BUTTON_BACKGROUND_BLACK, BUTTON_BACKGROUND_BLACK, button -> {
            ClientDragonRenderer.renderOtherPlayerSkins = ClientDragonRenderer.renderOtherPlayerSkins == false;
            ConfigHandler.updateConfigValue("render_other_players_custom_skins", ClientDragonRenderer.renderOtherPlayerSkins);
        }){

            @Override
            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
                guiGraphics.blit(ClientDragonRenderer.renderOtherPlayerSkins != false ? SKIN_ON : SKIN_OFF, this.getX() + 3, this.getY() + 5, 0.0f, 0.0f, 14, 14, 14, 14);
            }
        };
        toggleRenderingOtherSkins.setMessage((Component)Component.translatable((String)SHOW_OTHER_CUSTOM_SKINS));
        this.addRenderableWidget((GuiEventListener)toggleRenderingOtherSkins);
        HoverButton resetSkinButton = new HoverButton(startX + 20, startY + 128, 22, 21, 22, 21, RESET_SKIN_MAIN, RESET_SKIN_HOVER, button -> {
            playerName = Objects.requireNonNull(player).getGameProfile().getName();
        });
        this.addRenderableWidget((GuiEventListener)resetSkinButton);
        HoverButton randomSkinButton = new HoverButton(startX - 6, startY + 128, 22, 21, 22, 21, RANDOM_SKIN_MAIN, RANDOM_SKIN_HOVER, button -> {
            ArrayList<Pair> skins = new ArrayList<Pair>();
            HashSet<String> users = new HashSet<String>();
            Random random = new Random();
            for (Map.Entry<ResourceKey<DragonStage>, HashMap<String, SkinObject>> ent : DragonSkins.USER_SKINS.entrySet()) {
                for (Map.Entry<String, SkinObject> user : ent.getValue().entrySet()) {
                    if (user.getValue().glow) continue;
                    skins.add(Pair.of(ent.getKey(), (Object)user.getKey()));
                    users.add(user.getKey());
                }
            }
            skins.removeIf(pair -> SEEN_SKINS.contains(pair.second));
            while (!skins.isEmpty()) {
                Optional stage;
                Pair skin = (Pair)skins.remove(random.nextInt(skins.size()));
                if (skin == null || (stage = player.registryAccess().holder((ResourceKey)skin.first)).isEmpty()) continue;
                dragonStage = (Holder)stage.get();
                playerName = (String)skin.second;
                SEEN_SKINS.add((String)skin.second);
                if (SEEN_SKINS.size() < users.size() / 2) break;
                SEEN_SKINS.removeFirst();
                break;
            }
        });
        randomSkinButton.setTooltip(Tooltip.create((Component)Component.translatable((String)RANDOM_INFO)));
        this.addRenderableWidget((GuiEventListener)randomSkinButton);
        if (playerHandler.isDragon()) {
            HoverButton openEditorButton = new HoverButton(startX + 128, startY + 115, 165, 22, 165, 22, OPEN_EDITOR_MAIN, OPEN_EDITOR_HOVER, button -> ClientProxy.openDragonEditor(playerHandler.speciesKey(), false));
            openEditorButton.setMessage((Component)Component.translatable((String)OPEN_EDITOR));
            this.addRenderableWidget((GuiEventListener)openEditorButton);
        }
        HoverButton additionsBackground = new HoverButton(startX + 128 + 44, startY + 128 + 16, 69, 22, 69, 22, ADDITIONS_BACKGROUND, ADDITIONS_BACKGROUND, button -> {});
        this.addRenderableOnly((Renderable)additionsBackground);
        ExtendedButton oldTextureButton = new ExtendedButton(startX + 176, startY + 128 + 20, 14, 14, (Component)Component.empty(), button -> {
            boolean alreadyUsingDefaults = this.handler.getCurrentSkinPreset().isStageUsingDefaultSkin((ResourceKey<DragonStage>)dragonStage.getKey());
            this.handler.getCurrentSkinPreset().setAllStagesToUseDefaultSkin(!alreadyUsingDefaults);
            playerHandler.getCurrentSkinPreset().setAllStagesToUseDefaultSkin(!alreadyUsingDefaults);
            ClientProxy.sendClientData();
        }, Supplier::get){

            public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.blit(DragonSkinsScreen.this.handler.getCurrentSkinPreset().isAnyStageUsingDefaultSkin() ? OLD_TEXTURE_ON : OLD_TEXTURE_OFF, this.getX(), this.getY(), 0.0f, 0.0f, 14, 14, 14, 14);
            }
        };
        oldTextureButton.setTooltip(Tooltip.create((Component)Component.translatable((String)DEFAULT_SKIN_INFO)));
        this.addRenderableWidget((GuiEventListener)oldTextureButton);
        HoverButton helpButton = new HoverButton(startX + 176 + 16, startY + 128 + 20, 14, 14, 14, 14, INFO_MAIN, INFO_HOVER, button -> {});
        helpButton.setTooltip(Tooltip.create((Component)Component.translatable((String)HELP)));
        this.addRenderableWidget((GuiEventListener)helpButton);
        HoverButton discordButton = new HoverButton(startX + 176 + 32, startY + 128 + 20, 14, 14, 14, 14, DISCORD_MAIN, DISCORD_HOVER, ConfirmLinkScreen.confirmLink((Screen)this, (String)"https://discord.gg/8SsB8ar"));
        discordButton.setTooltip(Tooltip.create((Component)Component.translatable((String)LangKey.DISCORD)));
        this.addRenderableWidget((GuiEventListener)discordButton);
        HoverButton wikiButton = new HoverButton(startX + 176 + 48, startY + 128 + 20, 14, 14, 14, 14, WIKI_MAIN, WIKI_HOVER, ConfirmLinkScreen.confirmLink((Screen)this, (String)SKIN_WIKI_URL));
        wikiButton.setTooltip(Tooltip.create((Component)Component.translatable((String)WIKI)));
        this.addRenderableWidget((GuiEventListener)wikiButton);
    }

    private DragonBodyButton createButton(Holder<DragonBody> dragonBody, int x, int y) {
        return new DragonBodyButton(this, x, y, 35, 35, dragonBody, DragonBodyButton.LockedReason.NONE, button -> this.handler.setBody(null, dragonBody), true, true);
    }

    private void setTextures() {
        ResourceLocation skinTexture = DragonSkins.getPlayerSkin(playerName, (ResourceKey<DragonStage>)Objects.requireNonNull(dragonStage.getKey()));
        ResourceLocation glowTexture = null;
        boolean defaultSkin = false;
        if (!DragonSkins.renderCustomSkin(Objects.requireNonNull(this.minecraft).player) && playerName.equals(Objects.requireNonNull(this.minecraft.player).getGameProfile().getName()) || skinTexture == null) {
            skinTexture = null;
            defaultSkin = true;
        }
        if (skinTexture != null) {
            glowTexture = DragonSkins.getPlayerGlow(playerName, (ResourceKey<DragonStage>)dragonStage.getKey());
        }
        DragonSkinsScreen.glowTexture = glowTexture;
        DragonSkinsScreen.skinTexture = skinTexture;
        if (Objects.equals(lastPlayerName, playerName) || lastPlayerName == null) {
            this.zoom = DragonEditorScreen.setZoom(dragonStage);
        }
        noSkin = defaultSkin;
        lastPlayerName = playerName;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseDragged(double x1, double y1, int p_231045_5_, double x2, double y2) {
        this.xRot -= (float)(x2 / 5.0);
        this.yRot -= (float)(y2 / 5.0);
        return super.mouseDragged(x1, y1, p_231045_5_, x2, y2);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.zoom += (float)scrollY;
        this.zoom = Mth.clamp((float)this.zoom, (float)10.0f, (float)80.0f);
        return true;
    }
}

