/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.hud;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.util.RenderingUtils;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.StageResources;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonGrowthHandler;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import java.awt.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GrowthHUD {
    public static final ResourceLocation ID = DragonSurvival.res("growth_hud");
    private static final Color CENTER_COLOR = new Color(125, 125, 125);
    private static final Color OUTLINE_COLOR = new Color(125, 125, 125);
    private static final Color ADD_COLOR = new Color(0, 200, 0);
    private static final Color SUBTRACT_COLOR = new Color(200, 0, 0);
    private static final Color GROWTH_STOPPED_COLOR = new Color(255, 255, 255);
    @ConfigRange
    @Translation(key="growth_x_offset", type=Translation.Type.CONFIGURATION, comments={"Offset for the x position of the item growth icon"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "growth"}, key="growth_x_offset")
    public static Integer growthXOffset = 0;
    @ConfigRange
    @Translation(key="growth_y_offset", type=Translation.Type.CONFIGURATION, comments={"Offset for the y position of the item growth icon"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "growth"}, key="growth_y_offset")
    public static Integer growthYOffset = 0;

    public static void render(@NotNull GuiGraphics graphics, @NotNull DeltaTracker tracker) {
        float targetProgress;
        boolean progressDiffIsSmall;
        float desiredProgress;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isSpectator()) {
            return;
        }
        DragonStateHandler handler = DragonStateProvider.getData((Player)player);
        if (!handler.isDragon()) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        Holder<DragonStage> dragonStage = handler.stage();
        double nextSize = ((DragonStage)dragonStage.value()).growthRange().max();
        float currentProgress = (float)((DragonStage)dragonStage.value()).getProgress(handler.getGrowth());
        float progressDiff = Math.abs(currentProgress - (desiredProgress = (float)((DragonStage)dragonStage.value()).getProgress(handler.getDesiredGrowth())));
        boolean bl = progressDiffIsSmall = (double)progressDiff < 0.01;
        if (progressDiffIsSmall && (handler.getGrowth() == nextSize || ((DragonStage)dragonStage.value()).growthItems().stream().noneMatch(growthItem -> growthItem.canBeUsed(handler, stack.getItem())))) {
            return;
        }
        currentProgress = Math.min(1.0f, currentProgress);
        int radius = 17;
        int circleX = graphics.guiWidth() / 2 - radius;
        int circleY = graphics.guiHeight() - 90;
        circleX += growthXOffset.intValue();
        circleY += growthYOffset.intValue();
        Double growth = DragonGrowthHandler.getGrowth((Player)Minecraft.getInstance().player, handler, stack.getItem());
        Color addColor = ADD_COLOR;
        if (growth.isNaN()) {
            currentProgress = 0.0f;
            targetProgress = 1.0f;
            addColor = GROWTH_STOPPED_COLOR;
        } else {
            targetProgress = progressDiffIsSmall ? (float)((DragonStage)dragonStage.value()).getProgress(handler.getGrowth() + growth) : desiredProgress;
        }
        RenderingUtils.drawGrowthCircle(graphics, circleX, circleY, radius, 6, 0.13f, currentProgress, targetProgress, CENTER_COLOR, OUTLINE_COLOR, addColor, SUBTRACT_COLOR);
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 300.0f);
        graphics.blit(StageResources.getGrowthIcon(handler.species(), handler.stageKey()).hoverIcon(), circleX + 7, circleY + 6, 0.0f, 0.0f, 20, 20, 20, 20);
        graphics.pose().popPose();
    }
}

