/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.hud;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.PenaltySupply;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.PenaltyTrigger;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.SupplyTrigger;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class DragonPenaltyHUD {
    public static final ResourceLocation ID = DragonSurvival.res("penalty_hud");

    public static void render(@NotNull GuiGraphics graphics, @NotNull DeltaTracker tracker) {
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !Minecraft.getInstance().gameMode.canHurtPlayer()) {
            return;
        }
        if (!DragonStateProvider.isDragon((Entity)player)) {
            return;
        }
        PenaltySupply supply = player.getExistingData(DSDataAttachments.PENALTY_SUPPLY).orElse(null);
        if (supply == null) {
            return;
        }
        for (ResourceLocation supplyType : supply.getSupplyTypes()) {
            boolean displayLikeHungerBar = supply.getMatchingPenalty(supplyType, DragonStateProvider.getData((Player)player)).map(penalty -> {
                PenaltyTrigger patt0$temp = ((DragonPenalty)penalty.value()).trigger();
                if (patt0$temp instanceof SupplyTrigger) {
                    SupplyTrigger supplyTrigger = (SupplyTrigger)patt0$temp;
                    return supplyTrigger.displayLikeHungerBar();
                }
                return false;
            }).orElse(false);
            float supplyPercentage = supply.getPercentage(supplyType);
            boolean shouldRender = supply.hasSupply(supplyType) && supplyPercentage < 1.0f || displayLikeHungerBar;
            if (!shouldRender) continue;
            int rightHeight = Minecraft.getInstance().gui.rightHeight;
            Minecraft.getInstance().gui.rightHeight += 10;
            float vanillaSupplyPercentageOffset = 0.0055555557f;
            int left = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 + 91;
            int top = Minecraft.getInstance().getWindow().getGuiScaledHeight() - rightHeight;
            ResourceLocation supplyIcon = supplyType.withPrefix("textures/gui/custom/supply_icons/").withSuffix(".png");
            if (displayLikeHungerBar) {
                int foodLevel = Mth.ceil((float)(supplyPercentage * 20.0f));
                for (int i = 0; i < 10; ++i) {
                    int offset = 0;
                    if (player.tickCount % (foodLevel * 3 + 1) == 0 && supplyPercentage < 1.0f) {
                        offset = player.level().random.nextInt(3) - 1;
                    }
                    int uOffset = i * 2 + 1 < foodLevel ? 0 : (i * 2 + 1 == foodLevel ? 9 : 18);
                    graphics.blit(supplyIcon, left - i * 8 - 9, top + offset, 9, 9, (float)uOffset, 0.0f, 9, 9, 27, 9);
                }
                continue;
            }
            int full = Mth.ceil((float)((supplyPercentage - vanillaSupplyPercentageOffset) * 10.0f));
            int partial = Mth.ceil((float)(supplyPercentage * 10.0f)) - full;
            for (int i = 0; i < full + partial; ++i) {
                graphics.blit(supplyIcon, left - i * 8 - 9, top, 9, 9, i < full ? 0.0f : 9.0f, 0.0f, 9, 9, 18, 9);
            }
        }
    }
}

