/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui;

import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import java.util.List;

public enum DisplayType {
    HIDDEN,
    INVENTORY,
    GAME,
    INVENTORY_AND_GAME;

    @Translation(key="ability_effect_display_type", type=Translation.Type.CONFIGURATION, comments={"Determines how (or whether) ability effects should be displayed"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"effects"}, key="ability_effect_display_type")
    public static DisplayType DISPLAY_TYPE;
    @Translation(key="ability_effect_always_visible", type=Translation.Type.CONFIGURATION, comments={"Bypasses the set display type in case certain effects should be always visible (namespace:path)", "The id to be specified here can be seen when hovering the effect with advanced tooltips enabled"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"effects"}, key="ability_effect_always_visible")
    public static List<String> ALWAYS_VISIBLE;

    public static boolean isVisible(boolean isInventory) {
        return switch (DISPLAY_TYPE.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> false;
            case 3 -> true;
            case 1 -> isInventory;
            case 2 -> !isInventory;
        };
    }

    static {
        DISPLAY_TYPE = INVENTORY_AND_GAME;
        ALWAYS_VISIBLE = List.of("dragonsurvival:dragon_wings", "dragonsurvival:ender_dragon_curse");
    }
}

