/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.emotes;

import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.network.emotes.StopAllEmotes;
import by.dragonsurvivalteam.dragonsurvival.network.emotes.SyncEmote;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.emotes.DragonEmote;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(value={Dist.CLIENT})
public class EmoteHandler {
    private static final double EMOTE_MOVEMENT_EPSILON = 0.01;

    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Post event) {
        boolean isForLocalPlayer;
        if (!event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        DragonEntity dragon = ClientDragonRenderer.getDragon(player);
        if (dragon == null) {
            return;
        }
        dragon.clearSoundsPlayedThisTick();
        boolean bl = isForLocalPlayer = player == Minecraft.getInstance().player;
        if ((player.isCrouching() || player.swinging) && isForLocalPlayer) {
            dragon.stopAllEmotes();
            PacketDistributor.sendToServer((CustomPacketPayload)new StopAllEmotes(player.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        DragonEmote[] currentlyPlayingEmotes = dragon.getCurrentlyPlayingEmotes();
        boolean playerIsMoving = player.getDeltaMovement().lengthSqr() > 0.01;
        for (int i = 0; i < currentlyPlayingEmotes.length; ++i) {
            if (currentlyPlayingEmotes[i] == null) continue;
            if (currentlyPlayingEmotes[i].sound().isPresent()) {
                DragonEmote.Sound sound = currentlyPlayingEmotes[i].sound().get();
                if (dragon.getTicksForEmote(i) % sound.interval() == 0 && dragon.markEmoteSoundPlayedThisTick(i)) {
                    sound.playSound(player);
                }
            }
            if (!isForLocalPlayer) continue;
            if (!currentlyPlayingEmotes[i].canMove() && playerIsMoving) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SyncEmote(player.getId(), currentlyPlayingEmotes[i], true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                dragon.stopEmote(i);
                continue;
            }
            if (!currentlyPlayingEmotes[i].thirdPerson()) continue;
            Minecraft.getInstance().levelRenderer.needsUpdate();
            CameraType pointofview = Minecraft.getInstance().options.getCameraType();
            if (!pointofview.isFirstPerson()) continue;
            Minecraft.getInstance().options.setCameraType(CameraType.THIRD_PERSON_BACK);
            if (pointofview.isFirstPerson() == Minecraft.getInstance().options.getCameraType().isFirstPerson()) continue;
            Minecraft.getInstance().gameRenderer.checkEntityPostEffect(Minecraft.getInstance().options.getCameraType().isFirstPerson() ? Minecraft.getInstance().getCameraEntity() : null);
        }
    }

    @SubscribeEvent
    public static void playerAttacked(LivingIncomingDamageEvent event) {
        Player player;
        if (!event.getEntity().level().isClientSide()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && DragonStateProvider.isDragon((Entity)(player = (Player)livingEntity))) {
            DragonEntity dragon = ClientDragonRenderer.getDragon(player);
            if (dragon == null) {
                return;
            }
            dragon.stopAllEmotes();
            PacketDistributor.sendToServer((CustomPacketPayload)new StopAllEmotes(player.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

